/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import opennlp.tools.util.Sequence;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SequenceTest {
    @Test
    void testCopyConstructor() {
        Sequence sequence = new Sequence();
        sequence.add("a", 10.0);
        sequence.add("b", 20.0);
        Sequence copy = new Sequence(sequence);
        Assertions.assertEquals((Object)sequence.getOutcomes(), (Object)copy.getOutcomes());
        Assertions.assertArrayEquals((double[])copy.getProbs(), (double[])sequence.getProbs(), (double)0.0);
        Assertions.assertEquals((int)0, (int)sequence.compareTo(copy));
    }

    @Test
    void testAddMethod() {
        Sequence sequence = new Sequence();
        sequence.add("a", 10.0);
        Assertions.assertEquals((Object)"a", sequence.getOutcomes().get(0));
        Assertions.assertEquals((double)10.0, (double)sequence.getProbs()[0]);
    }

    @Test
    void testCompareTo() {
        Sequence lowScore = new Sequence();
        lowScore.add("A", 1.0);
        lowScore.add("B", 2.0);
        lowScore.add("C", 3.0);
        Sequence highScore = new Sequence();
        lowScore.add("A", 7.0);
        lowScore.add("B", 8.0);
        lowScore.add("C", 9.0);
        Assertions.assertEquals((int)-1, (int)lowScore.compareTo(highScore));
        Assertions.assertEquals((int)1, (int)highScore.compareTo(lowScore));
    }

    @Test
    void testToString() {
        new Sequence().toString();
        Sequence sequence = new Sequence();
        sequence.add("test", 0.1);
        sequence.toString();
    }

    @Test
    void testGetAtIndex() {
        Sequence sequence = new Sequence();
        sequence.add("A", 1.0);
        sequence.add("B", 2.0);
        sequence.add("C", 3.0);
        Assertions.assertEquals((int)3, (int)sequence.getSize());
        Assertions.assertEquals((Object)"A", (Object)sequence.getOutcome(0));
        Assertions.assertEquals((Object)"B", (Object)sequence.getOutcome(1));
        Assertions.assertEquals((Object)"C", (Object)sequence.getOutcome(2));
        Assertions.assertEquals((double)1.0, (double)sequence.getProb(0));
        Assertions.assertEquals((double)2.0, (double)sequence.getProb(1));
        Assertions.assertEquals((double)3.0, (double)sequence.getProb(2));
    }

    @Test
    void testGetAtIndexInvalid() {
        Sequence sequence = new Sequence();
        sequence.add("A", 1.0);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sequence.getOutcome(-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sequence.getOutcome(sequence.getSize() + 1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sequence.getProb(-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> sequence.getProb(sequence.getSize() + 1));
    }

    @Test
    void testListCopy() {
        Sequence sequence = new Sequence();
        sequence.add("A", 1.0);
        Assertions.assertEquals((int)1, (int)sequence.getSize());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> sequence.getOutcomes().add("This should fail! It should not be possible to modify the internal state"));
    }
}

