/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MockInputStreamFactory;
import opennlp.tools.util.PlainTextByLineStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PlainTextByLineStreamTest {
    static final String testString = "line1\nline2\nline3\r\nline4\n";

    @Test
    void testLineSegmentation() throws IOException {
        PlainTextByLineStream stream = new PlainTextByLineStream((InputStreamFactory)new MockInputStreamFactory(testString), StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"line1", (Object)stream.read());
        Assertions.assertEquals((Object)"line2", (Object)stream.read());
        Assertions.assertEquals((Object)"line3", (Object)stream.read());
        Assertions.assertEquals((Object)"line4", (Object)stream.read());
        Assertions.assertNull((Object)stream.read());
        stream.close();
    }

    @Test
    void testReset() throws IOException {
        PlainTextByLineStream stream = new PlainTextByLineStream((InputStreamFactory)new MockInputStreamFactory(testString), StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"line1", (Object)stream.read());
        Assertions.assertEquals((Object)"line2", (Object)stream.read());
        Assertions.assertEquals((Object)"line3", (Object)stream.read());
        stream.reset();
        Assertions.assertEquals((Object)"line1", (Object)stream.read());
        Assertions.assertEquals((Object)"line2", (Object)stream.read());
        Assertions.assertEquals((Object)"line3", (Object)stream.read());
        Assertions.assertEquals((Object)"line4", (Object)stream.read());
        Assertions.assertNull((Object)stream.read());
        stream.close();
    }
}

