/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.IOException;
import opennlp.tools.util.ObjectStreamUtils;
import opennlp.tools.util.ParagraphStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ParagraphStreamTest {
    @Test
    void testSimpleReading() throws IOException {
        try (ParagraphStream paraStream = new ParagraphStream(ObjectStreamUtils.createObjectStream((Object[])new String[]{"1", "2", "", "", "4", "5"}));){
            Assertions.assertEquals((Object)"1\n2\n", (Object)paraStream.read());
            Assertions.assertEquals((Object)"4\n5\n", (Object)paraStream.read());
            Assertions.assertNull((Object)paraStream.read());
        }
        paraStream = new ParagraphStream(ObjectStreamUtils.createObjectStream((Object[])new String[]{"1", "2", "", "", "4", "5", ""}));
        try {
            Assertions.assertEquals((Object)"1\n2\n", (Object)paraStream.read());
            Assertions.assertEquals((Object)"4\n5\n", (Object)paraStream.read());
            Assertions.assertNull((Object)paraStream.read());
        }
        finally {
            paraStream.close();
        }
    }

    @Test
    void testReset() throws IOException {
        try (ParagraphStream paraStream = new ParagraphStream(ObjectStreamUtils.createObjectStream((Object[])new String[]{"1", "2", "", "", "4", "5", ""}));){
            Assertions.assertEquals((Object)"1\n2\n", (Object)paraStream.read());
            paraStream.reset();
            Assertions.assertEquals((Object)"1\n2\n", (Object)paraStream.read());
            Assertions.assertEquals((Object)"4\n5\n", (Object)paraStream.read());
            Assertions.assertNull((Object)paraStream.read());
        }
    }
}

