/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ObjectStreamUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ObjectStreamUtilsTest {
    @Test
    void buildStreamTest() throws IOException {
        Object[] data = new String[]{"dog", "cat", "pig", "frog"};
        ObjectStream stream = ObjectStreamUtils.createObjectStream((Object[])data);
        this.compare((ObjectStream<String>)stream, (String[])data);
        List<Object> dataList = Arrays.asList(data);
        stream = ObjectStreamUtils.createObjectStream(Arrays.asList(data));
        this.compare((ObjectStream<String>)stream, (String[])data);
        Arrays.sort(data);
        stream = ObjectStreamUtils.createObjectStream(new TreeSet<Object>(dataList));
        this.compare((ObjectStream<String>)stream, (String[])data);
    }

    @Test
    void concatenateStreamTest() throws IOException {
        Object[] data1 = new String[]{"dog1", "cat1", "pig1", "frog1"};
        Object[] data2 = new String[]{"dog2", "cat2", "pig2", "frog2"};
        String[] expected = new String[]{"dog1", "cat1", "pig1", "frog1", "dog2", "cat2", "pig2", "frog2"};
        ObjectStream stream = ObjectStreamUtils.concatenateObjectStream((ObjectStream[])new ObjectStream[]{ObjectStreamUtils.createObjectStream((Object[])data1), ObjectStreamUtils.createObjectStream((Object[])data2)});
        this.compare((ObjectStream<String>)stream, expected);
        ArrayList<ObjectStream> listOfStreams = new ArrayList<ObjectStream>();
        listOfStreams.add(ObjectStreamUtils.createObjectStream((Object[])data1));
        listOfStreams.add(ObjectStreamUtils.createObjectStream((Object[])data2));
        stream = ObjectStreamUtils.concatenateObjectStream(listOfStreams);
        this.compare((ObjectStream<String>)stream, expected);
        HashSet<ObjectStream> streamSet = new HashSet<ObjectStream>();
        streamSet.add(ObjectStreamUtils.createObjectStream((Object[])data1));
        streamSet.add(ObjectStreamUtils.createObjectStream((Object[])data2));
        stream = ObjectStreamUtils.concatenateObjectStream(streamSet);
        this.compareUpToLastCharacter((ObjectStream<String>)stream, expected);
    }

    private void compare(ObjectStream<String> stream, String[] expectedValues) throws IOException {
        String value;
        int i = 0;
        while ((value = (String)stream.read()) != null) {
            Assertions.assertTrue((i < expectedValues.length ? 1 : 0) != 0, (String)("The stream is longer than expected at index: " + i + " expected length: " + expectedValues.length + " expectedValues" + Arrays.toString(expectedValues)));
            Assertions.assertEquals((Object)expectedValues[i++], (Object)value);
        }
    }

    private void compareUpToLastCharacter(ObjectStream<String> stream, String[] expectedValues) throws IOException {
        String value;
        int i = 0;
        while ((value = (String)stream.read()) != null) {
            Assertions.assertTrue((i < expectedValues.length ? 1 : 0) != 0, (String)("The stream is longer than expected at index: " + i + " expected length: " + expectedValues.length + " expectedValues" + Arrays.toString(expectedValues)));
            Assertions.assertEquals((Object)expectedValues[i].substring(0, expectedValues[i].length() - 1), (Object)value.substring(0, value.length() - 1));
            ++i;
        }
    }
}

