/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import opennlp.tools.util.InputStreamFactory;

public class MockInputStreamFactory
implements InputStreamFactory {
    private final File inputSourceFile;
    private final String inputSourceStr;
    private final Charset charset;

    public MockInputStreamFactory(File file) {
        this.inputSourceFile = file;
        this.inputSourceStr = null;
        this.charset = null;
    }

    public MockInputStreamFactory(String str) {
        this(str, StandardCharsets.UTF_8);
    }

    public MockInputStreamFactory(String str, Charset charset) {
        this.inputSourceFile = null;
        this.inputSourceStr = str;
        this.charset = charset;
    }

    public InputStream createInputStream() {
        if (this.inputSourceFile != null) {
            return this.getClass().getClassLoader().getResourceAsStream(this.inputSourceFile.getPath());
        }
        return new ByteArrayInputStream(this.inputSourceStr.getBytes(this.charset));
    }
}

