/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.stream.Stream;
import opennlp.tools.EnabledWhenCDNAvailable;
import opennlp.tools.models.ModelType;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.DownloadUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullAndEmptySource;
import org.junit.jupiter.params.provider.ValueSource;

public class DownloadUtilTest {
    private static final ModelType MT_TOKENIZER = ModelType.TOKENIZER;

    @ParameterizedTest(name="Verify \"{0}\" sentence model")
    @ValueSource(strings={"en", "fr", "de", "it", "nl", "bg", "ca", "cs", "da", "el", "es", "et", "eu", "fi", "hr", "hy", "is", "ka", "kk", "ko", "lv", "no", "pl", "pt", "ro", "ru", "sk", "sl", "sr", "sv", "tr", "uk"})
    @EnabledWhenCDNAvailable(hostname="dlcdn.apache.org")
    public void testDownloadModelByLanguage(String lang) throws IOException {
        SentenceModel model = (SentenceModel)DownloadUtil.downloadModel((String)lang, (ModelType)ModelType.SENTENCE_DETECTOR, SentenceModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)lang, (Object)model.getLanguage());
        Assertions.assertTrue((boolean)model.isLoadedFromSerialized());
    }

    @ParameterizedTest(name="Verify \"{0}\" tokenizer model")
    @MethodSource(value={"provideURLs"})
    @EnabledWhenCDNAvailable(hostname="dlcdn.apache.org")
    public void testDownloadModelByURL(String language, URL url) throws IOException {
        TokenizerModel model = (TokenizerModel)DownloadUtil.downloadModel((URL)url, TokenizerModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)language, (Object)model.getLanguage());
        Assertions.assertTrue((boolean)model.isLoadedFromSerialized());
    }

    @Test
    @EnabledWhenCDNAvailable(hostname="dlcdn.apache.org")
    public void testExistsModel() throws IOException {
        String lang = "en";
        ModelType type = ModelType.SENTENCE_DETECTOR;
        SentenceModel model = (SentenceModel)DownloadUtil.downloadModel((String)"en", (ModelType)type, SentenceModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)"en", (Object)model.getLanguage());
        Assertions.assertTrue((boolean)DownloadUtil.existsModel((String)"en", (ModelType)type));
    }

    @ParameterizedTest
    @NullAndEmptySource
    @ValueSource(strings={"xy", "\t", "\n"})
    @EnabledWhenCDNAvailable(hostname="dlcdn.apache.org")
    public void testExistsModelInvalid(String input) throws IOException {
        Assertions.assertFalse((boolean)DownloadUtil.existsModel((String)input, (ModelType)ModelType.SENTENCE_DETECTOR));
    }

    @ParameterizedTest(name="Detect invalid input: \"{0}\"")
    @NullAndEmptySource
    @ValueSource(strings={" ", "\t", "\n"})
    public void testDownloadModelInvalid(String input) {
        Assertions.assertThrows(IOException.class, () -> DownloadUtil.downloadModel((String)input, (ModelType)ModelType.SENTENCE_DETECTOR, SentenceModel.class), (String)"Invalid model");
    }

    public static Stream<Arguments> provideURLs() {
        return Stream.of(Arguments.of((Object[])new Object[]{"en", ((Map)DownloadUtil.getAvailableModels().get("en")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"fr", ((Map)DownloadUtil.getAvailableModels().get("fr")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"de", ((Map)DownloadUtil.getAvailableModels().get("de")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"it", ((Map)DownloadUtil.getAvailableModels().get("it")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"nl", ((Map)DownloadUtil.getAvailableModels().get("nl")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"bg", ((Map)DownloadUtil.getAvailableModels().get("bg")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"ca", ((Map)DownloadUtil.getAvailableModels().get("ca")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"cs", ((Map)DownloadUtil.getAvailableModels().get("cs")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"da", ((Map)DownloadUtil.getAvailableModels().get("da")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"el", ((Map)DownloadUtil.getAvailableModels().get("el")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"es", ((Map)DownloadUtil.getAvailableModels().get("es")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"et", ((Map)DownloadUtil.getAvailableModels().get("et")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"eu", ((Map)DownloadUtil.getAvailableModels().get("eu")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"fi", ((Map)DownloadUtil.getAvailableModels().get("fi")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"hr", ((Map)DownloadUtil.getAvailableModels().get("hr")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"hy", ((Map)DownloadUtil.getAvailableModels().get("hy")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"is", ((Map)DownloadUtil.getAvailableModels().get("is")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"ka", ((Map)DownloadUtil.getAvailableModels().get("ka")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"kk", ((Map)DownloadUtil.getAvailableModels().get("kk")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"ko", ((Map)DownloadUtil.getAvailableModels().get("ko")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"lv", ((Map)DownloadUtil.getAvailableModels().get("lv")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"no", ((Map)DownloadUtil.getAvailableModels().get("no")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"pl", ((Map)DownloadUtil.getAvailableModels().get("pl")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"pt", ((Map)DownloadUtil.getAvailableModels().get("pt")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"ro", ((Map)DownloadUtil.getAvailableModels().get("ro")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"ru", ((Map)DownloadUtil.getAvailableModels().get("ru")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"sk", ((Map)DownloadUtil.getAvailableModels().get("sk")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"sl", ((Map)DownloadUtil.getAvailableModels().get("sl")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"sr", ((Map)DownloadUtil.getAvailableModels().get("sr")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"sv", ((Map)DownloadUtil.getAvailableModels().get("sv")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"tr", ((Map)DownloadUtil.getAvailableModels().get("tr")).get(MT_TOKENIZER)}), Arguments.of((Object[])new Object[]{"uk", ((Map)DownloadUtil.getAvailableModels().get("uk")).get(MT_TOKENIZER)}));
    }
}

