/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.io.IOException;
import java.util.List;
import nl.altindag.log.LogCaptor;
import opennlp.tools.EnabledWhenCDNAvailable;
import opennlp.tools.models.ModelType;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.util.DownloadUtil;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;

@EnabledWhenCDNAvailable(hostname="dlcdn.apache.org")
public class DownloadUtilDownloadTwiceTest {
    @BeforeAll
    public static void prepare() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = context.getLogger("opennlp");
        logger.setLevel(Level.DEBUG);
    }

    @AfterAll
    public static void cleanup() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = context.getLogger("opennlp");
        logger.setLevel(Level.OFF);
    }

    @Test
    public void testDownloadModelTwice() throws IOException {
        String lang = "de";
        ModelType type = ModelType.SENTENCE_DETECTOR;
        try (LogCaptor logCaptor = LogCaptor.forClass(DownloadUtil.class);){
            boolean alreadyDownloaded = DownloadUtil.existsModel((String)lang, (ModelType)type);
            DownloadUtil.downloadModel((String)lang, (ModelType)type, SentenceModel.class);
            if (!alreadyDownloaded) {
                Assertions.assertEquals((int)2, (int)logCaptor.getDebugLogs().size());
                this.checkDebugLogsContainMessageFragment(logCaptor.getDebugLogs(), "Download complete.");
            } else {
                Assertions.assertEquals((int)1, (int)logCaptor.getDebugLogs().size());
                this.checkDebugLogsContainMessageFragment(logCaptor.getDebugLogs(), "already exists. Skipping download.");
            }
            logCaptor.clearLogs();
            DownloadUtil.downloadModel((String)lang, (ModelType)type, SentenceModel.class);
            Assertions.assertEquals((int)1, (int)logCaptor.getDebugLogs().size());
            this.checkDebugLogsContainMessageFragment(logCaptor.getDebugLogs(), "already exists. Skipping download.");
            logCaptor.clearLogs();
        }
    }

    private void checkDebugLogsContainMessageFragment(List<String> debugLogs, String message) {
        for (String log : debugLogs) {
            if (!log.contains(message)) continue;
            return;
        }
        throw new AssertionError((Object)("Expected message fragment not found in logs: " + message));
    }
}

