/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.stream.Stream;
import opennlp.tools.models.ModelType;
import opennlp.tools.util.DownloadUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class DownloadParserTest {
    private static final String OPENNLP = "opennlp-";
    private static final String MODEL_SENT = "sentence-";
    private static final String MODEL_TOK = "tokens-";
    private static final String MODEL_POS = "pos-";
    private static final String VER = "1.3-2.5.4";
    private static final String BIN = ".bin";

    @ParameterizedTest(name="Verify \"{0}\" available models")
    @MethodSource(value={"expectedModels"})
    void testAvailableModels(String language, Map<ModelType, String> expectedModels) {
        URL baseUrl = this.fromClasspath("opennlp/tools/util/index.html");
        Assertions.assertNotNull((Object)baseUrl);
        DownloadUtil.DownloadParser downloadParser = new DownloadUtil.DownloadParser(baseUrl);
        Map result = downloadParser.getAvailableModels();
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)36, (int)result.size());
        Map availableModels = (Map)result.get(language);
        Assertions.assertNotNull((Object)availableModels);
        for (Map.Entry<ModelType, String> e : expectedModels.entrySet()) {
            String url = (String)availableModels.get(e.getKey());
            String expectedUrl = String.valueOf(baseUrl) + "/" + e.getValue();
            Assertions.assertNotNull((Object)url, (String)"A model for the given model type is expected");
            Assertions.assertEquals((Object)expectedUrl, (Object)url);
        }
    }

    @Test
    void testNullUrl() {
        Assertions.assertThrows(NullPointerException.class, () -> new DownloadUtil.DownloadParser(null));
    }

    @Test
    void testInvalidUrl() throws MalformedURLException {
        DownloadUtil.DownloadParser downloadParser = new DownloadUtil.DownloadParser(new URL("file:/this/does/not/exist"));
        Map result = downloadParser.getAvailableModels();
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)0, (int)result.size());
    }

    private URL fromClasspath(String file) {
        return Thread.currentThread().getContextClassLoader().getResource(file);
    }

    public static Stream<Arguments> expectedModels() {
        return Stream.of(Arguments.of((Object[])new Object[]{"en", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-en-ud-ewt-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-en-ud-ewt-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-en-ud-ewt-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"fr", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-fr-ud-gsd-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-fr-ud-gsd-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-fr-ud-gsd-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"de", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-de-ud-gsd-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-de-ud-gsd-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-de-ud-gsd-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"it", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-it-ud-vit-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-it-ud-vit-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-it-ud-vit-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"nl", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-nl-ud-alpino-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-nl-ud-alpino-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-nl-ud-alpino-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"bg", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-bg-ud-btb-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-bg-ud-btb-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-bg-ud-btb-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"cs", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-cs-ud-pdtc-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-cs-ud-pdtc-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-cs-ud-pdtc-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"da", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-da-ud-ddt-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-da-ud-ddt-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-da-ud-ddt-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"es", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-es-ud-gsd-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-es-ud-gsd-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-es-ud-gsd-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"et", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-et-ud-edt-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-et-ud-edt-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-et-ud-edt-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"fi", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-fi-ud-tdt-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-fi-ud-tdt-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-fi-ud-tdt-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"hr", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-hr-ud-set-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-hr-ud-set-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-hr-ud-set-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"lv", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-lv-ud-lvtb-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-lv-ud-lvtb-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-lv-ud-lvtb-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"no", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-no-ud-bokmaal-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-no-ud-bokmaal-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-no-ud-bokmaal-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"pl", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-pl-ud-pdb-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-pl-ud-pdb-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-pl-ud-pdb-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"pt", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-pt-ud-gsd-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-pt-ud-gsd-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-pt-ud-gsd-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"ro", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-ro-ud-rrt-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-ro-ud-rrt-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-ro-ud-rrt-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"ru", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-ru-ud-gsd-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-ru-ud-gsd-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-ru-ud-gsd-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"sr", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-sr-ud-set-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-sr-ud-set-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-sr-ud-set-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"sk", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-sk-ud-snk-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-sk-ud-snk-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-sk-ud-snk-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"sl", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-sl-ud-ssj-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-sl-ud-ssj-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-sl-ud-ssj-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"sv", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-sv-ud-talbanken-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-sv-ud-talbanken-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-sv-ud-talbanken-pos-1.3-2.5.4.bin")}), Arguments.of((Object[])new Object[]{"uk", Map.of(ModelType.SENTENCE_DETECTOR, "opennlp-uk-ud-iu-sentence-1.3-2.5.4.bin", ModelType.TOKENIZER, "opennlp-uk-ud-iu-tokens-1.3-2.5.4.bin", ModelType.POS, "opennlp-uk-ud-iu-pos-1.3-2.5.4.bin")}));
    }
}

