/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.AbstractEventStream;
import opennlp.tools.util.CollectionObjectStream;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AbstractEventStreamTest {
    @Test
    void testStandardCase() throws IOException {
        ArrayList<RESULT> samples = new ArrayList<RESULT>();
        samples.add(RESULT.EVENTS);
        samples.add(RESULT.EMPTY);
        samples.add(RESULT.EVENTS);
        try (TestEventStream eventStream = new TestEventStream((ObjectStream<RESULT>)new CollectionObjectStream(samples));){
            int eventCounter = 0;
            while (eventStream.read() != null) {
                ++eventCounter;
            }
            Assertions.assertEquals((int)2, (int)eventCounter);
        }
    }

    @Test
    void testEmtpyEventStream() throws IOException {
        ArrayList<RESULT> samples = new ArrayList<RESULT>();
        samples.add(RESULT.EMPTY);
        try (TestEventStream eventStream = new TestEventStream((ObjectStream<RESULT>)new CollectionObjectStream(samples));){
            Assertions.assertNull((Object)eventStream.read());
            samples.add(RESULT.EMPTY);
            samples.add(RESULT.EMPTY);
        }
        eventStream = new TestEventStream((ObjectStream<RESULT>)new CollectionObjectStream(samples));
        try {
            Assertions.assertNull((Object)eventStream.read());
        }
        finally {
            eventStream.close();
        }
    }

    static enum RESULT {
        EVENTS,
        EMPTY;

    }

    static class TestEventStream
    extends AbstractEventStream<RESULT> {
        protected TestEventStream(ObjectStream<RESULT> samples) {
            super(samples);
        }

        protected Iterator<Event> createEvents(RESULT sample) {
            if (RESULT.EVENTS.equals((Object)sample)) {
                ArrayList<Event> events = new ArrayList<Event>();
                events.add(new Event("test", (CharSequence[])new String[]{"f1", "f2"}));
                return events.iterator();
            }
            if (RESULT.EMPTY.equals((Object)sample)) {
                List emptyList = Collections.emptyList();
                return emptyList.iterator();
            }
            Assertions.fail();
            return null;
        }
    }
}

