/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import opennlp.tools.tokenize.WhitespaceTokenizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WhitespaceTokenizerTest {
    @Test
    void testOneToken() {
        Assertions.assertEquals((Object)"one", (Object)WhitespaceTokenizer.INSTANCE.tokenize("one")[0]);
        Assertions.assertEquals((Object)"one", (Object)WhitespaceTokenizer.INSTANCE.tokenize(" one")[0]);
        Assertions.assertEquals((Object)"one", (Object)WhitespaceTokenizer.INSTANCE.tokenize("one ")[0]);
    }

    @Test
    void testWhitespaceTokenization() {
        String text = "a b c  d     e                f    ";
        String[] tokenizedText = WhitespaceTokenizer.INSTANCE.tokenize(text);
        Assertions.assertEquals((Object)"a", (Object)tokenizedText[0]);
        Assertions.assertEquals((Object)"b", (Object)tokenizedText[1]);
        Assertions.assertEquals((Object)"c", (Object)tokenizedText[2]);
        Assertions.assertEquals((Object)"d", (Object)tokenizedText[3]);
        Assertions.assertEquals((Object)"e", (Object)tokenizedText[4]);
        Assertions.assertEquals((Object)"f", (Object)tokenizedText[5]);
        Assertions.assertEquals((int)6, (int)tokenizedText.length);
    }

    @Test
    void testTokenizationOfStringWithoutTokens() {
        Assertions.assertEquals((int)0, (int)WhitespaceTokenizer.INSTANCE.tokenize("").length);
        Assertions.assertEquals((int)0, (int)WhitespaceTokenizer.INSTANCE.tokenize(" ").length);
        Assertions.assertEquals((int)0, (int)WhitespaceTokenizer.INSTANCE.tokenize(" ").length);
        Assertions.assertEquals((int)0, (int)WhitespaceTokenizer.INSTANCE.tokenize("     ").length);
    }

    @Test
    void testTokenizationOfStringWithUnixNewLineTokens() {
        WhitespaceTokenizer tokenizer = WhitespaceTokenizer.INSTANCE;
        tokenizer.setKeepNewLines(true);
        Assertions.assertEquals((int)2, (int)tokenizer.tokenize("a\n").length);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "\n"}, (Object[])tokenizer.tokenize("a\n"));
        Assertions.assertEquals((int)3, (int)tokenizer.tokenize("a\nb").length);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "\n", "b"}, (Object[])tokenizer.tokenize("a\nb"));
        Assertions.assertEquals((int)4, (int)tokenizer.tokenize("a\n\n b").length);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "\n", "\n", "b"}, (Object[])tokenizer.tokenize("a\n\n b"));
        Assertions.assertEquals((int)7, (int)tokenizer.tokenize("a\n\n b\n\n c").length);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "\n", "\n", "b", "\n", "\n", "c"}, (Object[])tokenizer.tokenize("a\n\n b\n\n c"));
    }

    @Test
    void testTokenizationOfStringWithWindowsNewLineTokens() {
        WhitespaceTokenizer tokenizer = WhitespaceTokenizer.INSTANCE;
        tokenizer.setKeepNewLines(true);
        Assertions.assertEquals((int)3, (int)tokenizer.tokenize("a\r\n").length);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "\r", "\n"}, (Object[])tokenizer.tokenize("a\r\n"));
        Assertions.assertEquals((int)4, (int)tokenizer.tokenize("a\r\nb").length);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "\r", "\n", "b"}, (Object[])tokenizer.tokenize("a\r\nb"));
        Assertions.assertEquals((int)6, (int)tokenizer.tokenize("a\r\n\r\n b").length);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "\r", "\n", "\r", "\n", "b"}, (Object[])tokenizer.tokenize("a\r\n\r\n b"));
        Assertions.assertEquals((int)11, (int)tokenizer.tokenize("a\r\n\r\n b\r\n\r\n c").length);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "\r", "\n", "\r", "\n", "b", "\r", "\n", "\r", "\n", "c"}, (Object[])tokenizer.tokenize("a\r\n\r\n b\r\n\r\n c"));
    }
}

