/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.IOException;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.TokenSampleStream;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerStream;
import opennlp.tools.tokenize.WhitespaceTokenStream;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ObjectStreamUtils;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WhitespaceTokenStreamTest {
    @Test
    void testWhitespace() throws IOException {
        String text = " a b c  d    e        f     ";
        TokenSampleStream sampleStream = new TokenSampleStream(ObjectStreamUtils.createObjectStream((Object[])new String[]{text}));
        WhitespaceTokenStream tokenStream = new WhitespaceTokenStream((ObjectStream)sampleStream);
        String read = tokenStream.read();
        Assertions.assertEquals((Object)"a b c d e f", (Object)read);
    }

    @Test
    void testSeparatedString() throws IOException {
        String text = " a b<SPLIT>c   d<SPLIT>e   ";
        TokenSampleStream sampleStream = new TokenSampleStream(ObjectStreamUtils.createObjectStream((Object[])new String[]{text}));
        WhitespaceTokenStream tokenStream = new WhitespaceTokenStream((ObjectStream)sampleStream);
        String read = tokenStream.read();
        Assertions.assertEquals((Object)"a b c d e", (Object)read);
    }

    @Test
    void testTokenizerStream() throws IOException {
        String text = " a b c  d    e      ";
        WhitespaceTokenizer instance = WhitespaceTokenizer.INSTANCE;
        TokenizerStream stream = new TokenizerStream((Tokenizer)instance, ObjectStreamUtils.createObjectStream((Object[])new String[]{text}));
        TokenSample read = stream.read();
        Span[] tokenSpans = read.getTokenSpans();
        Assertions.assertEquals((int)5, (int)tokenSpans.length);
        Assertions.assertEquals((Object)"a", (Object)tokenSpans[0].getCoveredText((CharSequence)read.getText()));
        Assertions.assertEquals((Object)new Span(1, 2), (Object)tokenSpans[0]);
        Assertions.assertEquals((Object)"b", (Object)tokenSpans[1].getCoveredText((CharSequence)read.getText()));
        Assertions.assertEquals((Object)new Span(3, 4), (Object)tokenSpans[1]);
        Assertions.assertEquals((Object)"c", (Object)tokenSpans[2].getCoveredText((CharSequence)read.getText()));
        Assertions.assertEquals((Object)new Span(5, 6), (Object)tokenSpans[2]);
        Assertions.assertEquals((Object)"d", (Object)tokenSpans[3].getCoveredText((CharSequence)read.getText()));
        Assertions.assertEquals((Object)new Span(8, 9), (Object)tokenSpans[3]);
        Assertions.assertEquals((Object)"e", (Object)tokenSpans[4].getCoveredText((CharSequence)read.getText()));
        Assertions.assertEquals((Object)new Span(13, 14), (Object)tokenSpans[4]);
    }
}

