/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import opennlp.tools.cmdline.tokenizer.TokenEvaluationErrorListener;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.TokenSampleTest;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerEvaluationMonitor;
import opennlp.tools.tokenize.TokenizerEvaluator;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TokenizerEvaluatorTest {
    @Test
    void testPositive() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TokenEvaluationErrorListener listener = new TokenEvaluationErrorListener((OutputStream)stream);
        TokenizerEvaluator eval = new TokenizerEvaluator((Tokenizer)new DummyTokenizer(TokenSampleTest.createGoldSample()), new TokenizerEvaluationMonitor[]{listener});
        eval.evaluateSample((Object)TokenSampleTest.createGoldSample());
        Assertions.assertEquals((double)1.0, (double)eval.getFMeasure().getFMeasure(), (double)0.0);
        Assertions.assertEquals((int)0, (int)((Object)stream).toString().length());
    }

    @Test
    void testNegative() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TokenEvaluationErrorListener listener = new TokenEvaluationErrorListener((OutputStream)stream);
        TokenizerEvaluator eval = new TokenizerEvaluator((Tokenizer)new DummyTokenizer(TokenSampleTest.createGoldSample()), new TokenizerEvaluationMonitor[]{listener});
        eval.evaluateSample((Object)TokenSampleTest.createPredSample());
        Assertions.assertEquals((double)0.5, (double)eval.getFMeasure().getFMeasure(), (double)0.1);
        Assertions.assertNotSame((Object)0, (Object)((Object)stream).toString().length());
    }

    static class DummyTokenizer
    implements Tokenizer {
        private final TokenSample sample;

        public DummyTokenizer(TokenSample sample) {
            this.sample = sample;
        }

        public String[] tokenize(String s) {
            return null;
        }

        public Span[] tokenizePos(String s) {
            return this.sample.getTokenSpans();
        }
    }
}

