/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import opennlp.tools.tokenize.Detokenizer;
import opennlp.tools.tokenize.DictionaryDetokenizerTest;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TokenSampleTest {
    public static TokenSample createGoldSample() {
        return new TokenSample("A test.", new Span[]{new Span(0, 1), new Span(2, 6)});
    }

    public static TokenSample createPredSample() {
        return new TokenSample("A test.", new Span[]{new Span(0, 3), new Span(2, 6)});
    }

    public static TokenSample createPredSilverSample() {
        return new TokenSample("A t st.", new Span[]{new Span(0, 1), new Span(2, 6)});
    }

    @Test
    void testRetrievingContent() {
        String sentence = "A test";
        TokenSample sample = new TokenSample(sentence, new Span[]{new Span(0, 1), new Span(2, 6)});
        Assertions.assertEquals((Object)"A test", (Object)sample.getText());
        Assertions.assertEquals((Object)new Span(0, 1), (Object)sample.getTokenSpans()[0]);
        Assertions.assertEquals((Object)new Span(2, 6), (Object)sample.getTokenSpans()[1]);
    }

    @Test
    void testTokenSampleSerDe() throws IOException {
        TokenSample tokenSample = TokenSampleTest.createGoldSample();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteArrayOutputStream);
        out.writeObject(tokenSample);
        out.flush();
        byte[] bytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        ObjectInputStream objectInput = new ObjectInputStream(byteArrayInputStream);
        TokenSample deSerializedTokenSample = null;
        try {
            deSerializedTokenSample = (TokenSample)objectInput.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Assertions.assertNotNull((Object)deSerializedTokenSample);
        Assertions.assertEquals((Object)tokenSample.getText(), (Object)deSerializedTokenSample.getText());
        Assertions.assertArrayEquals((Object[])tokenSample.getTokenSpans(), (Object[])deSerializedTokenSample.getTokenSpans());
    }

    @Test
    void testCreationWithDetokenizer() throws IOException {
        Detokenizer detokenizer = DictionaryDetokenizerTest.createLatinDetokenizer();
        String[] tokens = new String[]{"start", "(", ")", "end", ".", "hyphen", "-", "string", "."};
        TokenSample a = new TokenSample(detokenizer, tokens);
        Assertions.assertEquals((Object)"start () end. hyphen-string.", (Object)a.getText());
        Assertions.assertEquals((Object)"start (<SPLIT>) end<SPLIT>. hyphen<SPLIT>-<SPLIT>string<SPLIT>.", (Object)a.toString());
        Assertions.assertEquals((int)9, (int)a.getTokenSpans().length);
        Assertions.assertEquals((Object)new Span(0, 5), (Object)a.getTokenSpans()[0]);
        Assertions.assertEquals((Object)new Span(6, 7), (Object)a.getTokenSpans()[1]);
        Assertions.assertEquals((Object)new Span(7, 8), (Object)a.getTokenSpans()[2]);
        Assertions.assertEquals((Object)new Span(9, 12), (Object)a.getTokenSpans()[3]);
        Assertions.assertEquals((Object)new Span(12, 13), (Object)a.getTokenSpans()[4]);
        Assertions.assertEquals((Object)new Span(14, 20), (Object)a.getTokenSpans()[5]);
        Assertions.assertEquals((Object)new Span(20, 21), (Object)a.getTokenSpans()[6]);
        Assertions.assertEquals((Object)new Span(21, 27), (Object)a.getTokenSpans()[7]);
        Assertions.assertEquals((Object)new Span(27, 28), (Object)a.getTokenSpans()[8]);
    }

    @Test
    void testEquals() {
        Assertions.assertNotSame((Object)TokenSampleTest.createGoldSample(), (Object)TokenSampleTest.createGoldSample());
        Assertions.assertEquals((Object)TokenSampleTest.createGoldSample(), (Object)TokenSampleTest.createGoldSample());
        Assertions.assertNotEquals((Object)TokenSampleTest.createPredSample(), (Object)TokenSampleTest.createGoldSample());
        Assertions.assertNotEquals((Object)new Object(), (Object)TokenSampleTest.createPredSample());
    }
}

