/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.IOException;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.TokenSampleStream;
import opennlp.tools.util.ObjectStreamUtils;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TokenSampleStreamTest {
    @Test
    void testParsingWhitespaceSeparatedTokens() throws IOException {
        String sampleTokens = "Slave to the wage";
        TokenSampleStream sampleTokenStream = new TokenSampleStream(ObjectStreamUtils.createObjectStream((Object[])new String[]{sampleTokens}));
        TokenSample tokenSample = (TokenSample)sampleTokenStream.read();
        Span[] tokenSpans = tokenSample.getTokenSpans();
        Assertions.assertEquals((int)4, (int)tokenSpans.length);
        Assertions.assertEquals((Object)"Slave", (Object)tokenSpans[0].getCoveredText((CharSequence)sampleTokens));
        Assertions.assertEquals((Object)"to", (Object)tokenSpans[1].getCoveredText((CharSequence)sampleTokens));
        Assertions.assertEquals((Object)"the", (Object)tokenSpans[2].getCoveredText((CharSequence)sampleTokens));
        Assertions.assertEquals((Object)"wage", (Object)tokenSpans[3].getCoveredText((CharSequence)sampleTokens));
    }

    @Test
    void testParsingSeparatedString() throws IOException {
        String sampleTokens = "a<SPLIT>b<SPLIT>c<SPLIT>d";
        TokenSampleStream sampleTokenStream = new TokenSampleStream(ObjectStreamUtils.createObjectStream((Object[])new String[]{sampleTokens}));
        TokenSample tokenSample = (TokenSample)sampleTokenStream.read();
        Span[] tokenSpans = tokenSample.getTokenSpans();
        Assertions.assertEquals((int)4, (int)tokenSpans.length);
        Assertions.assertEquals((Object)"a", (Object)tokenSpans[0].getCoveredText((CharSequence)tokenSample.getText()));
        Assertions.assertEquals((Object)new Span(0, 1), (Object)tokenSpans[0]);
        Assertions.assertEquals((Object)"b", (Object)tokenSpans[1].getCoveredText((CharSequence)tokenSample.getText()));
        Assertions.assertEquals((Object)new Span(1, 2), (Object)tokenSpans[1]);
        Assertions.assertEquals((Object)"c", (Object)tokenSpans[2].getCoveredText((CharSequence)tokenSample.getText()));
        Assertions.assertEquals((Object)new Span(2, 3), (Object)tokenSpans[2]);
        Assertions.assertEquals((Object)"d", (Object)tokenSpans[3].getCoveredText((CharSequence)tokenSample.getText()));
        Assertions.assertEquals((Object)new Span(3, 4), (Object)tokenSpans[3]);
    }

    @Test
    void testParsingWhitespaceAndSeparatedString() throws IOException {
        String sampleTokens = "a b<SPLIT>c d<SPLIT>e";
        try (TokenSampleStream sampleTokenStream = new TokenSampleStream(ObjectStreamUtils.createObjectStream((Object[])new String[]{sampleTokens}));){
            TokenSample tokenSample = (TokenSample)sampleTokenStream.read();
            Span[] tokenSpans = tokenSample.getTokenSpans();
            Assertions.assertEquals((int)5, (int)tokenSpans.length);
            Assertions.assertEquals((Object)"a", (Object)tokenSpans[0].getCoveredText((CharSequence)tokenSample.getText()));
            Assertions.assertEquals((Object)"b", (Object)tokenSpans[1].getCoveredText((CharSequence)tokenSample.getText()));
            Assertions.assertEquals((Object)"c", (Object)tokenSpans[2].getCoveredText((CharSequence)tokenSample.getText()));
            Assertions.assertEquals((Object)"d", (Object)tokenSpans[3].getCoveredText((CharSequence)tokenSample.getText()));
            Assertions.assertEquals((Object)"e", (Object)tokenSpans[4].getCoveredText((CharSequence)tokenSample.getText()));
        }
    }
}

