/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import opennlp.tools.tokenize.SimpleTokenizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleTokenizerTest {
    private final SimpleTokenizer mTokenizer = SimpleTokenizer.INSTANCE;

    @Test
    void testWhitespaceTokenization() {
        String text = "a b c  d     e                f    ";
        String[] tokenizedText = this.mTokenizer.tokenize(text);
        Assertions.assertEquals((Object)"a", (Object)tokenizedText[0]);
        Assertions.assertEquals((Object)"b", (Object)tokenizedText[1]);
        Assertions.assertEquals((Object)"c", (Object)tokenizedText[2]);
        Assertions.assertEquals((Object)"d", (Object)tokenizedText[3]);
        Assertions.assertEquals((Object)"e", (Object)tokenizedText[4]);
        Assertions.assertEquals((Object)"f", (Object)tokenizedText[5]);
        Assertions.assertEquals((int)6, (int)tokenizedText.length);
    }

    @Test
    void testWordDotTokenization() {
        String text = "a.";
        String[] tokenizedText = this.mTokenizer.tokenize(text);
        Assertions.assertEquals((Object)"a", (Object)tokenizedText[0]);
        Assertions.assertEquals((Object)".", (Object)tokenizedText[1]);
        Assertions.assertEquals((int)2, (int)tokenizedText.length);
    }

    @Test
    void testWordNumericTokeniztation() {
        String text = "305KW";
        String[] tokenizedText = this.mTokenizer.tokenize(text);
        Assertions.assertEquals((Object)"305", (Object)tokenizedText[0]);
        Assertions.assertEquals((Object)"KW", (Object)tokenizedText[1]);
        Assertions.assertEquals((int)2, (int)tokenizedText.length);
    }

    @Test
    void testWordWithOtherTokenization() {
        String text = "rebecca.sleep()";
        String[] tokenizedText = this.mTokenizer.tokenize(text);
        Assertions.assertEquals((Object)"rebecca", (Object)tokenizedText[0]);
        Assertions.assertEquals((Object)".", (Object)tokenizedText[1]);
        Assertions.assertEquals((Object)"sleep", (Object)tokenizedText[2]);
        Assertions.assertEquals((Object)"(", (Object)tokenizedText[3]);
        Assertions.assertEquals((Object)")", (Object)tokenizedText[4]);
        Assertions.assertEquals((int)5, (int)tokenizedText.length);
    }

    @Test
    void testTokenizationOfStringWithUnixNewLineTokens() {
        SimpleTokenizer tokenizer = SimpleTokenizer.INSTANCE;
        tokenizer.setKeepNewLines(true);
        Assertions.assertEquals((int)2, (int)tokenizer.tokenize("a\n").length);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "\n"}, (Object[])tokenizer.tokenize("a\n"));
        Assertions.assertEquals((int)3, (int)tokenizer.tokenize("a\nb").length);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "\n", "b"}, (Object[])tokenizer.tokenize("a\nb"));
        Assertions.assertEquals((int)4, (int)tokenizer.tokenize("a\n\n b").length);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "\n", "\n", "b"}, (Object[])tokenizer.tokenize("a\n\n b"));
        Assertions.assertEquals((int)7, (int)tokenizer.tokenize("a\n\n b\n\n c").length);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "\n", "\n", "b", "\n", "\n", "c"}, (Object[])tokenizer.tokenize("a\n\n b\n\n c"));
    }

    @Test
    void testTokenizationOfStringWithWindowsNewLineTokens() {
        SimpleTokenizer tokenizer = SimpleTokenizer.INSTANCE;
        tokenizer.setKeepNewLines(true);
        Assertions.assertEquals((int)3, (int)tokenizer.tokenize("a\r\n").length);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "\r", "\n"}, (Object[])tokenizer.tokenize("a\r\n"));
        Assertions.assertEquals((int)4, (int)tokenizer.tokenize("a\r\nb").length);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "\r", "\n", "b"}, (Object[])tokenizer.tokenize("a\r\nb"));
        Assertions.assertEquals((int)6, (int)tokenizer.tokenize("a\r\n\r\n b").length);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "\r", "\n", "\r", "\n", "b"}, (Object[])tokenizer.tokenize("a\r\n\r\n b"));
        Assertions.assertEquals((int)11, (int)tokenizer.tokenize("a\r\n\r\n b\r\n\r\n c").length);
        Assertions.assertArrayEquals((Object[])new String[]{"a", "\r", "\n", "\r", "\n", "b", "\r", "\n", "\r", "\n", "c"}, (Object[])tokenizer.tokenize("a\r\n\r\n b\r\n\r\n c"));
    }

    @Test
    void testNonSpacingLetters() {
        String text = "\u062a\u0645\u0651 \u0637\u064f\u0648\u0651\u0631 \u0627\u0644\u0645\u0634\u0631\u0648\u0639 \u0628\u0646\u062c\u0627\u062d.";
        String[] tokenizedText = this.mTokenizer.tokenize(text);
        Assertions.assertEquals((int)5, (int)tokenizedText.length);
        Assertions.assertEquals((Object)"\u062a\u0645\u0651", (Object)tokenizedText[0]);
        Assertions.assertEquals((Object)"\u0637\u064f\u0648\u0651\u0631", (Object)tokenizedText[1]);
        Assertions.assertEquals((Object)"\u0627\u0644\u0645\u0634\u0631\u0648\u0639", (Object)tokenizedText[2]);
        Assertions.assertEquals((Object)"\u0628\u0646\u062c\u0627\u062d", (Object)tokenizedText[3]);
        Assertions.assertEquals((Object)".", (Object)tokenizedText[4]);
    }
}

