/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.tokenize.DefaultTokenContextGenerator;
import opennlp.tools.tokenize.TokenContextGenerator;
import opennlp.tools.tokenize.TokenizerFactory;
import opennlp.tools.util.model.ArtifactSerializer;

public class DummyTokenizerFactory
extends TokenizerFactory {
    private static final String DUMMY_DICT = "dummy";
    private DummyDictionary dict;

    public DummyTokenizerFactory() {
    }

    public DummyTokenizerFactory(String languageCode, Dictionary abbreviationDictionary, boolean useAlphaNumericOptimization, Pattern alphaNumericPattern) {
        super(languageCode, abbreviationDictionary, useAlphaNumericOptimization, alphaNumericPattern);
    }

    protected void init(String languageCode, Dictionary abbreviationDictionary, boolean useAlphaNumericOptimization, Pattern alphaNumericPattern) {
        super.init(languageCode, abbreviationDictionary, useAlphaNumericOptimization, alphaNumericPattern);
        this.dict = new DummyDictionary(abbreviationDictionary);
    }

    public DummyDictionary getAbbreviationDictionary() {
        if (this.dict == null && this.artifactProvider != null) {
            this.dict = (DummyDictionary)((Object)this.artifactProvider.getArtifact(DUMMY_DICT));
        }
        return this.dict;
    }

    public TokenContextGenerator getContextGenerator() {
        return new DummyContextGenerator(this.getAbbreviationDictionary().asStringSet());
    }

    public Map<String, ArtifactSerializer<?>> createArtifactSerializersMap() {
        Map serializers = super.createArtifactSerializersMap();
        serializers.put(DUMMY_DICT, new DummyDictionarySerializer());
        return serializers;
    }

    public Map<String, Object> createArtifactMap() {
        Map artifactMap = super.createArtifactMap();
        if (this.dict != null) {
            artifactMap.put(DUMMY_DICT, this.dict);
        }
        return artifactMap;
    }

    public static class DummyDictionary
    extends Dictionary {
        private final Dictionary indict;

        public DummyDictionary(Dictionary dict) {
            this.indict = dict;
        }

        public DummyDictionary(InputStream in) throws IOException {
            this.indict = new Dictionary(in);
        }

        public void serialize(OutputStream out) throws IOException {
            this.indict.serialize(out);
        }

        public Set<String> asStringSet() {
            return this.indict.asStringSet();
        }

        public Class<?> getArtifactSerializerClass() {
            return DummyDictionarySerializer.class;
        }
    }

    static class DummyContextGenerator
    extends DefaultTokenContextGenerator {
        public DummyContextGenerator(Set<String> inducedAbbreviations) {
            super(inducedAbbreviations);
        }
    }

    public static class DummyDictionarySerializer
    implements ArtifactSerializer<DummyDictionary> {
        public DummyDictionary create(InputStream in) throws IOException {
            return new DummyDictionary(in);
        }

        public void serialize(DummyDictionary artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

