/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.tokenize.DetokenizationDictionary;
import opennlp.tools.tokenize.Detokenizer;
import opennlp.tools.tokenize.DictionaryDetokenizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DictionaryDetokenizerTest {
    @Test
    void testDetokenizer() {
        String[] tokens = new String[]{".", "!", "(", ")", "\"", "-"};
        DetokenizationDictionary.Operation[] operations = new DetokenizationDictionary.Operation[]{DetokenizationDictionary.Operation.MOVE_LEFT, DetokenizationDictionary.Operation.MOVE_LEFT, DetokenizationDictionary.Operation.MOVE_RIGHT, DetokenizationDictionary.Operation.MOVE_LEFT, DetokenizationDictionary.Operation.RIGHT_LEFT_MATCHING, DetokenizationDictionary.Operation.MOVE_BOTH};
        DetokenizationDictionary dict = new DetokenizationDictionary(tokens, operations);
        DictionaryDetokenizer detokenizer = new DictionaryDetokenizer(dict);
        Detokenizer.DetokenizationOperation[] detokenizeOperations = detokenizer.detokenize(new String[]{"Simple", "test", ".", "co", "-", "worker"});
        Assertions.assertEquals((Object)Detokenizer.DetokenizationOperation.NO_OPERATION, (Object)detokenizeOperations[0]);
        Assertions.assertEquals((Object)Detokenizer.DetokenizationOperation.NO_OPERATION, (Object)detokenizeOperations[1]);
        Assertions.assertEquals((Object)Detokenizer.DetokenizationOperation.MERGE_TO_LEFT, (Object)detokenizeOperations[2]);
        Assertions.assertEquals((Object)Detokenizer.DetokenizationOperation.NO_OPERATION, (Object)detokenizeOperations[3]);
        Assertions.assertEquals((Object)Detokenizer.DetokenizationOperation.MERGE_BOTH, (Object)detokenizeOperations[4]);
        Assertions.assertEquals((Object)Detokenizer.DetokenizationOperation.NO_OPERATION, (Object)detokenizeOperations[5]);
    }

    static Detokenizer createLatinDetokenizer() throws IOException {
        try (InputStream dictIn = DictionaryDetokenizerTest.class.getResourceAsStream("/opennlp/tools/tokenize/latin-detokenizer.xml");){
            DetokenizationDictionary dict = new DetokenizationDictionary(dictIn);
            DictionaryDetokenizer dictionaryDetokenizer = new DictionaryDetokenizer(dict);
            return dictionaryDetokenizer;
        }
    }

    @Test
    void testDetokenizeToString() throws IOException {
        Detokenizer detokenizer = DictionaryDetokenizerTest.createLatinDetokenizer();
        String[] tokens = new String[]{"A", "test", ",", "(", "string", ")", "."};
        String sentence = detokenizer.detokenize(tokens, null);
        Assertions.assertEquals((Object)"A test, (string).", (Object)sentence);
    }

    @Test
    void testDetokenizeToString2() throws IOException {
        Detokenizer detokenizer = DictionaryDetokenizerTest.createLatinDetokenizer();
        String[] tokens = new String[]{"A", "co", "-", "worker", "helped", "."};
        String sentence = detokenizer.detokenize(tokens, null);
        Assertions.assertEquals((Object)"A co-worker helped.", (Object)sentence);
    }
}

