/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import opennlp.tools.cmdline.tokenizer.DetokenEvaluationErrorListener;
import opennlp.tools.tokenize.Detokenizer;
import opennlp.tools.tokenize.DetokenizerEvaluator;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.TokenSampleTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DetokenizerEvaluatorTest {
    @Test
    void testPositive() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DetokenEvaluationErrorListener listener = new DetokenEvaluationErrorListener((OutputStream)stream);
        DetokenizerEvaluator eval = new DetokenizerEvaluator((Detokenizer)new DummyDetokenizer(TokenSampleTest.createGoldSample()), new DetokenEvaluationErrorListener[]{listener});
        eval.evaluateSample((Object)TokenSampleTest.createGoldSample());
        Assertions.assertEquals((double)1.0, (double)eval.getFMeasure().getFMeasure(), (double)0.0);
        Assertions.assertEquals((int)0, (int)((Object)stream).toString().length());
    }

    @Test
    void testNegative() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DetokenEvaluationErrorListener listener = new DetokenEvaluationErrorListener((OutputStream)stream);
        DetokenizerEvaluator eval = new DetokenizerEvaluator((Detokenizer)new DummyDetokenizer(TokenSampleTest.createGoldSample()), new DetokenEvaluationErrorListener[]{listener});
        eval.evaluateSample((Object)TokenSampleTest.createPredSilverSample());
        Assertions.assertEquals((double)-1.0, (double)eval.getFMeasure().getFMeasure(), (double)0.1);
        Assertions.assertNotSame((Object)0, (Object)((Object)stream).toString().length());
    }

    static class DummyDetokenizer
    implements Detokenizer {
        private final TokenSample sample;

        public DummyDetokenizer(TokenSample sample) {
            this.sample = sample;
        }

        public Detokenizer.DetokenizationOperation[] detokenize(String[] tokens) {
            return null;
        }

        public String detokenize(String[] tokens, String splitMarker) {
            return this.sample.getText();
        }
    }
}

