/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import opennlp.tools.tokenize.DetokenizationDictionary;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DetokenizationDictionaryTest {
    private DetokenizationDictionary dict;

    @BeforeEach
    void setUp() {
        String[] tokens = new String[]{"\"", "(", ")", "-"};
        DetokenizationDictionary.Operation[] operations = new DetokenizationDictionary.Operation[]{DetokenizationDictionary.Operation.RIGHT_LEFT_MATCHING, DetokenizationDictionary.Operation.MOVE_RIGHT, DetokenizationDictionary.Operation.MOVE_LEFT, DetokenizationDictionary.Operation.MOVE_BOTH};
        this.dict = new DetokenizationDictionary(tokens, operations);
    }

    private static void testEntries(DetokenizationDictionary dict) {
        Assertions.assertEquals((Object)DetokenizationDictionary.Operation.RIGHT_LEFT_MATCHING, (Object)dict.getOperation("\""));
        Assertions.assertEquals((Object)DetokenizationDictionary.Operation.MOVE_RIGHT, (Object)dict.getOperation("("));
        Assertions.assertEquals((Object)DetokenizationDictionary.Operation.MOVE_LEFT, (Object)dict.getOperation(")"));
        Assertions.assertEquals((Object)DetokenizationDictionary.Operation.MOVE_BOTH, (Object)dict.getOperation("-"));
    }

    @Test
    void testSimpleDict() {
        DetokenizationDictionaryTest.testEntries(this.dict);
    }

    @Test
    void testSerialization() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.dict.serialize((OutputStream)out);
        DetokenizationDictionary parsedDict = new DetokenizationDictionary((InputStream)new ByteArrayInputStream(out.toByteArray()));
        DetokenizationDictionaryTest.testEntries(parsedDict);
    }
}

