/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.stemmer;

import opennlp.tools.stemmer.snowball.SnowballStemmer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SnowballStemmerTest {
    @Test
    void testArabic() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.ARABIC);
        Assertions.assertEquals((Object)"\u0627\u0628\u0627\u0621", (Object)stemmer.stem((CharSequence)"\u0623\u0623\u0628\u0627\u0621\u0627\u0647\u0645"));
        Assertions.assertEquals((Object)"\u0627\u0633\u062a\u0641\u062a\u064a", (Object)stemmer.stem((CharSequence)"\u0627\u0633\u062a\u0641\u062a\u064a\u0627\u0643\u0645\u0627"));
        Assertions.assertEquals((Object)"\u0627\u0633\u062a\u0646\u062a\u0627\u062c\u0627", (Object)stemmer.stem((CharSequence)"\u0627\u0633\u062a\u0646\u062a\u0627\u062c\u0627\u062a\u0647\u0645\u0627"));
    }

    @Test
    void testDanish() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.DANISH);
        Assertions.assertEquals((Object)"aabenbaring", (Object)stemmer.stem((CharSequence)"aabenbaringen"));
        Assertions.assertEquals((Object)"skuebr\u00f8dsbord", (Object)stemmer.stem((CharSequence)"skuebr\u00f8dsbordene"));
        Assertions.assertEquals((Object)"skr\u00f8b", (Object)stemmer.stem((CharSequence)"skr\u00f8beligheder"));
    }

    @Test
    void testDutch() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.DUTCH);
        Assertions.assertEquals((Object)"vliegtuigtransport", (Object)stemmer.stem((CharSequence)"vliegtuigtransport"));
        Assertions.assertEquals((Object)"sterlabcertificat", (Object)stemmer.stem((CharSequence)"sterlabcertificaat"));
        Assertions.assertEquals((Object)"vollegrondsgroenteteelt", (Object)stemmer.stem((CharSequence)"vollegrondsgroenteteelt"));
    }

    @Test
    void testCatalan() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.CATALAN);
        Assertions.assertEquals((Object)"important", (Object)stemmer.stem((CharSequence)"important\u00edssimes"));
        Assertions.assertEquals((Object)"bes", (Object)stemmer.stem((CharSequence)"besar"));
        Assertions.assertEquals((Object)"accidental", (Object)stemmer.stem((CharSequence)"accidentalment"));
    }

    @Test
    void testEnglish() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.ENGLISH);
        Assertions.assertEquals((Object)"accompani", (Object)stemmer.stem((CharSequence)"accompanying"));
        Assertions.assertEquals((Object)"maledict", (Object)stemmer.stem((CharSequence)"malediction"));
        Assertions.assertEquals((Object)"soften", (Object)stemmer.stem((CharSequence)"softeners"));
    }

    @Test
    void testStemThis() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.ENGLISH);
        Assertions.assertEquals((Object)"this", (Object)stemmer.stem((CharSequence)"this"));
    }

    @Test
    void testFinnish() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.FINNISH);
        Assertions.assertEquals((Object)"esiintymispaik", (Object)stemmer.stem((CharSequence)"esiintymispaikasta"));
        Assertions.assertEquals((Object)"esiintyvi\u00e4taiteilijayst\u00e4vi\u00e4", (Object)stemmer.stem((CharSequence)"esiintyvi\u00e4taiteilijayst\u00e4vi\u00e4\u00e4n"));
        Assertions.assertEquals((Object)"hellberg", (Object)stemmer.stem((CharSequence)"hellbergi\u00e4"));
    }

    @Test
    void testFrench() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.FRENCH);
        Assertions.assertEquals((Object)"accompl", (Object)stemmer.stem((CharSequence)"accomplissaient"));
        Assertions.assertEquals((Object)"examin", (Object)stemmer.stem((CharSequence)"examinateurs"));
        Assertions.assertEquals((Object)"pr\u00e9voi", (Object)stemmer.stem((CharSequence)"pr\u00e9voyant"));
    }

    @Test
    void testGerman() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.GERMAN);
        Assertions.assertEquals((Object)"buchbindergesell", (Object)stemmer.stem((CharSequence)"buchbindergesellen"));
        Assertions.assertEquals((Object)"mind", (Object)stemmer.stem((CharSequence)"mindere"));
        Assertions.assertEquals((Object)"mitverursacht", (Object)stemmer.stem((CharSequence)"mitverursacht"));
    }

    @Test
    void testGreek() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.GREEK);
        Assertions.assertEquals((Object)"\u03b5\u03c0\u03b9\u03c3\u03c4\u03c1\u03bf\u03c6", (Object)stemmer.stem((CharSequence)"\u03b5\u03c0\u03b9\u03c3\u03c4\u03c1\u03bf\u03c6\u03ae"));
        Assertions.assertEquals((Object)"\u03b1\u03bc\u03b5\u03c1\u03b9\u03ba\u03b1\u03bd", (Object)stemmer.stem((CharSequence)"\u0391\u03bc\u03b5\u03c1\u03b9\u03ba\u03b1\u03bd\u03ce\u03bd"));
        Assertions.assertEquals((Object)"\u03c3\u03c4\u03c1\u03b1\u03c4\u03b9\u03c9\u03c4", (Object)stemmer.stem((CharSequence)"\u03c3\u03c4\u03c1\u03b1\u03c4\u03b9\u03c9\u03c4\u03ce\u03bd"));
    }

    @Test
    void testHungarian() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.HUNGARIAN);
        Assertions.assertEquals((Object)"abbahagyna", (Object)stemmer.stem((CharSequence)"abbahagyn\u00e1m"));
        Assertions.assertEquals((Object)"konstrukci\u00f3", (Object)stemmer.stem((CharSequence)"konstrukci\u00f3j\u00e1b\u00f3l"));
        Assertions.assertEquals((Object)"lopt", (Object)stemmer.stem((CharSequence)"lopta"));
    }

    @Test
    void testIrish() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.IRISH);
        Assertions.assertEquals((Object)"feidhm", (Object)stemmer.stem((CharSequence)"bhfeidhm"));
        Assertions.assertEquals((Object)"feirmeoir", (Object)stemmer.stem((CharSequence)"feirmeoireacht"));
        Assertions.assertEquals((Object)"monarc", (Object)stemmer.stem((CharSequence)"monarcacht"));
    }

    @Test
    void testItalian() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.ITALIAN);
        Assertions.assertEquals((Object)"abbatt", (Object)stemmer.stem((CharSequence)"abbattimento"));
        Assertions.assertEquals((Object)"dancer", (Object)stemmer.stem((CharSequence)"dancer"));
        Assertions.assertEquals((Object)"danc", (Object)stemmer.stem((CharSequence)"dance"));
    }

    @Test
    void testIndonesian() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.INDONESIAN);
        Assertions.assertEquals((Object)"ledak", (Object)stemmer.stem((CharSequence)"peledakan"));
        Assertions.assertEquals((Object)"ajar", (Object)stemmer.stem((CharSequence)"pelajaran"));
        Assertions.assertEquals((Object)"baik", (Object)stemmer.stem((CharSequence)"perbaikan"));
    }

    @Test
    void testPortuguese() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.PORTUGUESE);
        Assertions.assertEquals((Object)"aborrec", (Object)stemmer.stem((CharSequence)"aborrecimentos"));
        Assertions.assertEquals((Object)"ach\u00e9", (Object)stemmer.stem((CharSequence)"ach\u00e9"));
        Assertions.assertEquals((Object)"ache", (Object)stemmer.stem((CharSequence)"ache"));
    }

    @Test
    void testRomanian() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.ROMANIAN);
        Assertions.assertEquals((Object)"absurd", (Object)stemmer.stem((CharSequence)"absurdit\u0103\u0163ilor"));
        Assertions.assertEquals((Object)"la\u0219", (Object)stemmer.stem((CharSequence)"la\u015fi"));
        Assertions.assertEquals((Object)"sarac", (Object)stemmer.stem((CharSequence)"saracilor"));
    }

    @Test
    void testSpanish() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.SPANISH);
        Assertions.assertEquals((Object)"bes", (Object)stemmer.stem((CharSequence)"bes\u00f3"));
        Assertions.assertEquals((Object)"importantisim", (Object)stemmer.stem((CharSequence)"important\u00edsimas"));
        Assertions.assertEquals((Object)"incidental", (Object)stemmer.stem((CharSequence)"incidental"));
    }

    @Test
    void testSwedish() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.SWEDISH);
        Assertions.assertEquals((Object)"aftonringning", (Object)stemmer.stem((CharSequence)"aftonringningen"));
        Assertions.assertEquals((Object)"andedrag", (Object)stemmer.stem((CharSequence)"andedrag"));
        Assertions.assertEquals((Object)"andedr\u00e4g", (Object)stemmer.stem((CharSequence)"andedr\u00e4gt"));
    }

    @Test
    void testTurkish() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.TURKISH);
        Assertions.assertEquals((Object)"ab'yle", (Object)stemmer.stem((CharSequence)"ab'yle"));
        Assertions.assertEquals((Object)"ka\u00e7mamak", (Object)stemmer.stem((CharSequence)"ka\u00e7mamaktad\u0131r"));
        Assertions.assertEquals((Object)"saray\u0131'n\u0131", (Object)stemmer.stem((CharSequence)"saray\u0131'n\u0131"));
    }

    @Test
    void testFinish() {
        SnowballStemmer stemmer = new SnowballStemmer(SnowballStemmer.ALGORITHM.FINNISH);
        Assertions.assertEquals((Object)"edelt\u00e4n", (Object)stemmer.stem((CharSequence)"edelt\u00e4neeseen"));
        Assertions.assertEquals((Object)"voita", (Object)stemmer.stem((CharSequence)"voitaisiin"));
        Assertions.assertEquals((Object)"innostuks", (Object)stemmer.stem((CharSequence)"innostuksessaan"));
    }
}

