/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.stemmer;

import opennlp.tools.stemmer.PorterStemmer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class PorterStemmerTest {
    private PorterStemmer stemmer;

    @BeforeEach
    public void setup() {
        this.stemmer = new PorterStemmer();
    }

    @Test
    void testStem() {
        Assertions.assertEquals((Object)"deni", (Object)this.stemmer.stem("deny"));
        Assertions.assertEquals((Object)"declin", (Object)this.stemmer.stem("declining"));
        Assertions.assertEquals((Object)"divers", (Object)this.stemmer.stem("diversity"));
        Assertions.assertEquals((Object)"diver", (Object)this.stemmer.stem("divers"));
        Assertions.assertEquals((Object)"dental", (Object)this.stemmer.stem("dental"));
    }

    @ParameterizedTest
    @ValueSource(strings={"likes", "liked", "likely", "liking"})
    void testStemLike(String input) {
        Assertions.assertEquals((Object)"like", (Object)this.stemmer.stem(input));
    }

    @Test
    void testStemThis() {
        Assertions.assertEquals((Object)"thi", (Object)this.stemmer.stem("this"));
    }
}

