/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SentenceSampleTest {
    @Test
    void testRetrievingContent() {
        SentenceSample sample = new SentenceSample((CharSequence)"1. 2.", new Span[]{new Span(0, 2), new Span(3, 5)});
        Assertions.assertEquals((Object)"1. 2.", (Object)sample.getDocument());
        Assertions.assertEquals((Object)new Span(0, 2), (Object)sample.getSentences()[0]);
        Assertions.assertEquals((Object)new Span(3, 5), (Object)sample.getSentences()[1]);
    }

    @Test
    void testSentenceSampleSerDe() throws IOException {
        SentenceSample sentenceSample = SentenceSampleTest.createGoldSample();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteArrayOutputStream);
        out.writeObject(sentenceSample);
        out.flush();
        byte[] bytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        ObjectInputStream objectInput = new ObjectInputStream(byteArrayInputStream);
        SentenceSample deSerializedSentenceSample = null;
        try {
            deSerializedSentenceSample = (SentenceSample)objectInput.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Assertions.assertNotNull((Object)deSerializedSentenceSample);
        Assertions.assertEquals((Object)sentenceSample.getDocument(), (Object)deSerializedSentenceSample.getDocument());
        Assertions.assertArrayEquals((Object[])sentenceSample.getSentences(), (Object[])deSerializedSentenceSample.getSentences());
    }

    @Test
    void testInvalidSpansFailFast() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            SentenceSample sample = new SentenceSample((CharSequence)"1. 2.", new Span[]{new Span(0, 2), new Span(5, 7)});
        });
    }

    @Test
    void testEquals() {
        Assertions.assertNotSame((Object)SentenceSampleTest.createGoldSample(), (Object)SentenceSampleTest.createGoldSample());
        Assertions.assertEquals((Object)SentenceSampleTest.createGoldSample(), (Object)SentenceSampleTest.createGoldSample());
        Assertions.assertNotEquals((Object)SentenceSampleTest.createPredSample(), (Object)SentenceSampleTest.createGoldSample());
        Assertions.assertNotEquals((Object)new Object(), (Object)SentenceSampleTest.createPredSample());
    }

    public static SentenceSample createGoldSample() {
        return new SentenceSample((CharSequence)"1. 2.", new Span[]{new Span(0, 2), new Span(3, 5)});
    }

    public static SentenceSample createPredSample() {
        return new SentenceSample((CharSequence)"1. 2.", new Span[]{new Span(0, 1), new Span(4, 5)});
    }
}

