/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.formats.ResourceAsStreamFactory;
import opennlp.tools.sentdetect.AbstractSentenceDetectorTest;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.sentdetect.SentenceSampleStream;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.InsufficientTrainingDataException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class SentenceDetectorMETest
extends AbstractSentenceDetectorTest {
    private static SentenceModel sentdetectModel;

    @BeforeAll
    public static void prepareResources() throws IOException {
        Dictionary abbreviationDict = SentenceDetectorMETest.loadAbbDictionary(Locale.ENGLISH);
        SentenceDetectorFactory factory = new SentenceDetectorFactory("eng", true, abbreviationDict, null);
        sentdetectModel = SentenceDetectorMETest.train(factory, Locale.ENGLISH);
        Assertions.assertNotNull((Object)sentdetectModel);
        Assertions.assertEquals((Object)"eng", (Object)sentdetectModel.getLanguage());
    }

    @Test
    void testSentDetect() {
        SentenceDetectorME sentDetect = new SentenceDetectorME(sentdetectModel);
        String sampleSentences1 = "This is a test. There are many tests, this is the second.";
        String[] sents = sentDetect.sentDetect((CharSequence)sampleSentences1);
        Assertions.assertEquals((int)2, (int)sents.length);
        Assertions.assertEquals((Object)"This is a test.", (Object)sents[0]);
        Assertions.assertEquals((Object)"There are many tests, this is the second.", (Object)sents[1]);
        double[] probs = sentDetect.probs();
        Assertions.assertEquals((int)2, (int)probs.length);
        String sampleSentences2 = "This is a test. There are many tests, this is the second";
        sents = sentDetect.sentDetect((CharSequence)sampleSentences2);
        Assertions.assertEquals((int)2, (int)sents.length);
        probs = sentDetect.probs();
        Assertions.assertEquals((int)2, (int)probs.length);
        Assertions.assertEquals((Object)"This is a test.", (Object)sents[0]);
        Assertions.assertEquals((Object)"There are many tests, this is the second", (Object)sents[1]);
        String sampleSentences3 = "This is a \"test\". He said \"There are many tests, this is the second.\"";
        sents = sentDetect.sentDetect((CharSequence)sampleSentences3);
        Assertions.assertEquals((int)2, (int)sents.length);
        probs = sentDetect.probs();
        Assertions.assertEquals((int)2, (int)probs.length);
        Assertions.assertEquals((Object)"This is a \"test\".", (Object)sents[0]);
        Assertions.assertEquals((Object)"He said \"There are many tests, this is the second.\"", (Object)sents[1]);
        String sampleSentences4 = "This is a \"test\". I said \"This is a test.\"  Any questions?";
        sents = sentDetect.sentDetect((CharSequence)sampleSentences4);
        Assertions.assertEquals((int)3, (int)sents.length);
        probs = sentDetect.probs();
        Assertions.assertEquals((int)3, (int)probs.length);
        Assertions.assertEquals((Object)"This is a \"test\".", (Object)sents[0]);
        Assertions.assertEquals((Object)"I said \"This is a test.\"", (Object)sents[1]);
        Assertions.assertEquals((Object)"Any questions?", (Object)sents[2]);
        String sampleSentences5 = "This is a one sentence test space at the end.    ";
        sents = sentDetect.sentDetect((CharSequence)sampleSentences5);
        Assertions.assertEquals((int)1, (int)sentDetect.probs().length);
        Assertions.assertEquals((Object)"This is a one sentence test space at the end.", (Object)sents[0]);
        String sampleSentences6 = "This is a one sentences test with tab at the end.            ";
        sents = sentDetect.sentDetect((CharSequence)sampleSentences6);
        Assertions.assertEquals((Object)"This is a one sentences test with tab at the end.", (Object)sents[0]);
        String sampleSentences7 = "This is a test.    With spaces between the two sentences.";
        sents = sentDetect.sentDetect((CharSequence)sampleSentences7);
        Assertions.assertEquals((Object)"This is a test.", (Object)sents[0]);
        Assertions.assertEquals((Object)"With spaces between the two sentences.", (Object)sents[1]);
        String sampleSentences9 = "";
        sents = sentDetect.sentDetect((CharSequence)sampleSentences9);
        Assertions.assertEquals((int)0, (int)sents.length);
        String sampleSentences10 = "               ";
        sents = sentDetect.sentDetect((CharSequence)sampleSentences10);
        Assertions.assertEquals((int)0, (int)sents.length);
        String sampleSentences11 = "This is test sentence without a dot at the end and spaces          ";
        sents = sentDetect.sentDetect((CharSequence)sampleSentences11);
        Assertions.assertEquals((Object)"This is test sentence without a dot at the end and spaces", (Object)sents[0]);
        probs = sentDetect.probs();
        Assertions.assertEquals((int)1, (int)probs.length);
        String sampleSentence12 = "    This is a test.";
        sents = sentDetect.sentDetect((CharSequence)sampleSentence12);
        Assertions.assertEquals((Object)"This is a test.", (Object)sents[0]);
        String sampleSentence13 = " This is a test";
        sents = sentDetect.sentDetect((CharSequence)sampleSentence13);
        Assertions.assertEquals((Object)"This is a test", (Object)sents[0]);
        Span[] pos = sentDetect.sentPosDetect((CharSequence)sampleSentences2);
        Assertions.assertEquals((int)2, (int)pos.length);
        probs = sentDetect.probs();
        Assertions.assertEquals((int)2, (int)probs.length);
        Assertions.assertEquals((Object)new Span(0, 15), (Object)pos[0]);
        Assertions.assertEquals((Object)new Span(16, 56), (Object)pos[1]);
    }

    @Test
    void testSentDetectWithInlineAbbreviations() {
        SentenceDetectorME sentDetect = new SentenceDetectorME(sentdetectModel);
        String sampleSentences1 = "This is a test for Mr. Miller. His wife, Ms. Susan Miller, is also part of this test.";
        String[] sents = sentDetect.sentDetect((CharSequence)sampleSentences1);
        Assertions.assertEquals((int)2, (int)sents.length);
        Assertions.assertEquals((Object)"This is a test for Mr. Miller.", (Object)sents[0]);
        Assertions.assertEquals((Object)"His wife, Ms. Susan Miller, is also part of this test.", (Object)sents[1]);
        double[] probs = sentDetect.probs();
        Assertions.assertEquals((int)2, (int)probs.length);
    }

    @Test
    void testTrainWithInsufficientData() {
        Assertions.assertThrows(InsufficientTrainingDataException.class, () -> {
            ResourceAsStreamFactory in = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/sentdetect/SentencesInsufficient.txt");
            TrainingParameters mlParams = new TrainingParameters();
            mlParams.put("Iterations", 100);
            mlParams.put("Cutoff", 0);
            SentenceDetectorFactory factory = new SentenceDetectorFactory("eng", true, null, null);
            SentenceDetectorME.train((String)"eng", (ObjectStream)new SentenceSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)in, StandardCharsets.UTF_8)), (SentenceDetectorFactory)factory, (TrainingParameters)mlParams);
        });
    }
}

