/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.IOException;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.sentdetect.AbstractSentenceDetectorTest;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class SentenceDetectorMESpanishTest
extends AbstractSentenceDetectorTest {
    private static final char[] EOS_CHARS = new char[]{'.', '?', '!'};
    private static SentenceModel sentdetectModel;

    @BeforeAll
    public static void prepareResources() throws IOException {
        Dictionary abbreviationDict = SentenceDetectorMESpanishTest.loadAbbDictionary(LOCALE_SPANISH);
        SentenceDetectorFactory factory = new SentenceDetectorFactory("spa", true, abbreviationDict, EOS_CHARS);
        sentdetectModel = SentenceDetectorMESpanishTest.train(factory, LOCALE_SPANISH);
        Assertions.assertNotNull((Object)sentdetectModel);
        Assertions.assertEquals((Object)"spa", (Object)sentdetectModel.getLanguage());
    }

    @ParameterizedTest
    @ValueSource(strings={"El panel de color que abro (cf. el an\u00e1lisis de la p\u00e1g. 185) trata un tema nuevo", "El panel de color que abro (p.ej. el an\u00e1lisis de la p\u00e1g. 185) trata un tema nuevo", "El caballo se come la ensalada de pepino con el n.\u00ba dos."})
    void testSentDetectWithInlineAbbreviationsResultsInOneSentence(String input) {
        SentenceDetectorME sentDetect = new SentenceDetectorME(sentdetectModel);
        String[] sents = sentDetect.sentDetect((CharSequence)input);
        Assertions.assertEquals((int)1, (int)sents.length);
        Assertions.assertEquals((Object)input, (Object)sents[0]);
        double[] probs = sentDetect.probs();
        Assertions.assertEquals((int)1, (int)probs.length);
    }

    @Test
    void testSentDetectWithInlineAbbreviationsResultsInTwoSentences() {
        String sent1 = "Ya Arist\u00f3teles cre\u00eda en la posibilidad de hallar en los sue\u00f1os la indicaci\u00f3ndel comienzo de una enfermedad de la que en el estado de vigilia no experiment\u00e1bamos a\u00fanel menor indicio (merced a la ampliaci\u00f3n que el sue\u00f1o deja experimentar a lasimpresiones), y autores m\u00e9dicos de cuyas opiniones se hallaba muy lejos el conceder a lossue\u00f1os un valor prof\u00e9tico, han aceptado esta significaci\u00f3n de los mismos comoanunciadores de la enfermedad (cf. Sim\u00f3n, p\u00e1g. 31, y otros muchos autores m\u00e1santiguos).";
        String sent2 = "Tampoco en la \u00e9poca moderna faltan ejemplos comprobados de una tal funci\u00f3n diagn\u00f3stica del sue\u00f1o.";
        String sampleSentences = "Ya Arist\u00f3teles cre\u00eda en la posibilidad de hallar en los sue\u00f1os la indicaci\u00f3ndel comienzo de una enfermedad de la que en el estado de vigilia no experiment\u00e1bamos a\u00fanel menor indicio (merced a la ampliaci\u00f3n que el sue\u00f1o deja experimentar a lasimpresiones), y autores m\u00e9dicos de cuyas opiniones se hallaba muy lejos el conceder a lossue\u00f1os un valor prof\u00e9tico, han aceptado esta significaci\u00f3n de los mismos comoanunciadores de la enfermedad (cf. Sim\u00f3n, p\u00e1g. 31, y otros muchos autores m\u00e1santiguos). Tampoco en la \u00e9poca moderna faltan ejemplos comprobados de una tal funci\u00f3n diagn\u00f3stica del sue\u00f1o.";
        SentenceDetectorME sentDetect = new SentenceDetectorME(sentdetectModel);
        String[] sents = sentDetect.sentDetect((CharSequence)sampleSentences);
        Assertions.assertEquals((int)2, (int)sents.length);
        Assertions.assertEquals((Object)"Ya Arist\u00f3teles cre\u00eda en la posibilidad de hallar en los sue\u00f1os la indicaci\u00f3ndel comienzo de una enfermedad de la que en el estado de vigilia no experiment\u00e1bamos a\u00fanel menor indicio (merced a la ampliaci\u00f3n que el sue\u00f1o deja experimentar a lasimpresiones), y autores m\u00e9dicos de cuyas opiniones se hallaba muy lejos el conceder a lossue\u00f1os un valor prof\u00e9tico, han aceptado esta significaci\u00f3n de los mismos comoanunciadores de la enfermedad (cf. Sim\u00f3n, p\u00e1g. 31, y otros muchos autores m\u00e1santiguos).", (Object)sents[0]);
        Assertions.assertEquals((Object)"Tampoco en la \u00e9poca moderna faltan ejemplos comprobados de una tal funci\u00f3n diagn\u00f3stica del sue\u00f1o.", (Object)sents[1]);
        double[] probs = sentDetect.probs();
        Assertions.assertEquals((int)2, (int)probs.length);
    }
}

