/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.IOException;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.sentdetect.AbstractSentenceDetectorTest;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class SentenceDetectorMEPortugueseTest
extends AbstractSentenceDetectorTest {
    private static final char[] EOS_CHARS = new char[]{'.', '?', '!'};
    private static SentenceModel sentdetectModel;

    @BeforeAll
    public static void prepareResources() throws IOException {
        Dictionary abbreviationDict = SentenceDetectorMEPortugueseTest.loadAbbDictionary(LOCALE_PORTUGUESE);
        SentenceDetectorFactory factory = new SentenceDetectorFactory("por", true, abbreviationDict, EOS_CHARS);
        sentdetectModel = SentenceDetectorMEPortugueseTest.train(factory, LOCALE_PORTUGUESE);
        Assertions.assertNotNull((Object)sentdetectModel);
        Assertions.assertEquals((Object)"por", (Object)sentdetectModel.getLanguage());
    }

    @ParameterizedTest
    @ValueSource(strings={"Medico \u00e9 o Dr. Avelino, d'aqui a legoa e meia, nas Bolsas.", "Mas j\u00e1 V. Ex.a v\u00ea, esta gentinha \u00e9 pobre!", "S. Alteza o Gran-Duque Casimiro!"})
    void testSentDetectWithInlineAbbreviationsResultsInOneSentence(String input) {
        SentenceDetectorME sentDetect = new SentenceDetectorME(sentdetectModel);
        String[] sents = sentDetect.sentDetect((CharSequence)input);
        Assertions.assertEquals((int)1, (int)sents.length);
        Assertions.assertEquals((Object)input, (Object)sents[0]);
        double[] probs = sentDetect.probs();
        Assertions.assertEquals((int)1, (int)probs.length);
    }

    @Test
    void testSentDetectWithInlineAbbreviationsResultsInTwoSentences() {
        String sent1 = "O povo pernambucano, tradicionalmente inimigo dos imperadores, lembrava-se do tempo em que o Sr. D. Pedro de Alcantara dava-se ao luxo de visitar o norte.";
        String sent2 = "S. Exc.a soffre de fartura.";
        String sampleSentences = "O povo pernambucano, tradicionalmente inimigo dos imperadores, lembrava-se do tempo em que o Sr. D. Pedro de Alcantara dava-se ao luxo de visitar o norte. S. Exc.a soffre de fartura.";
        SentenceDetectorME sentDetect = new SentenceDetectorME(sentdetectModel);
        String[] sents = sentDetect.sentDetect((CharSequence)sampleSentences);
        Assertions.assertEquals((int)2, (int)sents.length);
        Assertions.assertEquals((Object)"O povo pernambucano, tradicionalmente inimigo dos imperadores, lembrava-se do tempo em que o Sr. D. Pedro de Alcantara dava-se ao luxo de visitar o norte.", (Object)sents[0]);
        Assertions.assertEquals((Object)"S. Exc.a soffre de fartura.", (Object)sents[1]);
        double[] probs = sentDetect.probs();
        Assertions.assertEquals((int)2, (int)probs.length);
    }
}

