/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.IOException;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.sentdetect.AbstractSentenceDetectorTest;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class SentenceDetectorMEPolishTest
extends AbstractSentenceDetectorTest {
    private static final char[] EOS_CHARS = new char[]{'.', '?', '!'};
    private static SentenceModel sentdetectModel;

    @BeforeAll
    public static void prepareResources() throws IOException {
        Dictionary abbreviationDict = SentenceDetectorMEPolishTest.loadAbbDictionary(LOCALE_POLISH);
        SentenceDetectorFactory factory = new SentenceDetectorFactory("pol", true, abbreviationDict, EOS_CHARS);
        sentdetectModel = SentenceDetectorMEPolishTest.train(factory, LOCALE_POLISH);
        Assertions.assertNotNull((Object)sentdetectModel);
        Assertions.assertEquals((Object)"pol", (Object)sentdetectModel.getLanguage());
    }

    @ParameterizedTest
    @ValueSource(strings={"Freud zauwa\u017cy\u0142, \u017ce w normalnych warunkach silne pobudzenie emocjonalne wymaga odpowiedniego roz\u0142adowania w formie dzia\u0142ania (np. uraza ze strony jakiej\u015b osoby wymaga odwetu) lub opracowania intelektualnego.", "Z tego pierwszego badania mo\u017cna odnie\u015b\u0107 wra\u017cenie, \u017ce elementy \"botaniczny\" i \"monografia\" znalaz\u0142y si\u0119 w tre\u015bci snu, poniewa\u017c mog\u0105 mie\u0107 najszerszy kontakt z wi\u0119kszo\u015bci\u0105 my\u015bli sennych, tj. reprezentuj\u0105 punkty w\u0119z\u0142owe, w kt\u00f3rych spotyka si\u0119 wiele my\u015bli sennych, poniewa\u017c s\u0105 one niejednoznaczne w odniesieniu do interpretacji sn\u00f3w."})
    void testSentDetectWithInlineAbbreviationsResultsInOneSentence(String input) {
        SentenceDetectorME sentDetect = new SentenceDetectorME(sentdetectModel);
        String[] sents = sentDetect.sentDetect((CharSequence)input);
        Assertions.assertEquals((int)1, (int)sents.length);
        Assertions.assertEquals((Object)input, (Object)sents[0]);
        double[] probs = sentDetect.probs();
        Assertions.assertEquals((int)1, (int)probs.length);
    }

    @Test
    void testSentDetectWithInlineAbbreviationsResultsInTwoSentences() {
        String sent1 = "W szkicu autobiograficznym pt. moje \u017cycie i psychoanaliza Freud pisze, \u017ce jego przodkowie \u017cyli przez wiele lat w Kolonii.";
        String sent2 = "W wyniku prze\u015bladowa\u0144 \u017byd\u00f3w w XIV i XV wieku uciekli na wsch\u00f3d do Polski i na Litw\u0119.";
        String sampleSentences = "W szkicu autobiograficznym pt. moje \u017cycie i psychoanaliza Freud pisze, \u017ce jego przodkowie \u017cyli przez wiele lat w Kolonii. W wyniku prze\u015bladowa\u0144 \u017byd\u00f3w w XIV i XV wieku uciekli na wsch\u00f3d do Polski i na Litw\u0119.";
        SentenceDetectorME sentDetect = new SentenceDetectorME(sentdetectModel);
        String[] sents = sentDetect.sentDetect((CharSequence)sampleSentences);
        Assertions.assertEquals((int)2, (int)sents.length);
        Assertions.assertEquals((Object)"W szkicu autobiograficznym pt. moje \u017cycie i psychoanaliza Freud pisze, \u017ce jego przodkowie \u017cyli przez wiele lat w Kolonii.", (Object)sents[0]);
        Assertions.assertEquals((Object)"W wyniku prze\u015bladowa\u0144 \u017byd\u00f3w w XIV i XV wieku uciekli na wsch\u00f3d do Polski i na Litw\u0119.", (Object)sents[1]);
        double[] probs = sentDetect.probs();
        Assertions.assertEquals((int)2, (int)probs.length);
    }
}

