/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.formats.ResourceAsStreamFactory;
import opennlp.tools.sentdetect.AbstractSentenceDetectorTest;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.PlainTextByLineStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class SentenceDetectorMEItalianTest
extends AbstractSentenceDetectorTest {
    private static final char[] EOS_CHARS = new char[]{'.', '?', '!'};
    private static SentenceModel sentdetectModel;

    @BeforeAll
    public static void prepareResources() throws IOException {
        Dictionary abbreviationDict = SentenceDetectorMEItalianTest.loadAbbDictionary(Locale.ITALIAN);
        SentenceDetectorFactory factory = new SentenceDetectorFactory("ita", true, abbreviationDict, EOS_CHARS);
        sentdetectModel = SentenceDetectorMEItalianTest.train(factory, Locale.ITALIAN);
        Assertions.assertNotNull((Object)sentdetectModel);
        Assertions.assertEquals((Object)"ita", (Object)sentdetectModel.getLanguage());
    }

    @ParameterizedTest
    @ValueSource(strings={"La chiesa fu costruita fra il 1258 ed il 1308 ca. come chiesa del convento degli Agostiniani.", "Laureato in Scienza Politiche presso l'Universit\u00e0 S. Pio V, di Roma.", "La chiesa, che prima dipendeva da S. Giovanni Battista sopra Quarona, fu innalzata parrocchia nel 1588, con la posa della croce sulla sommit\u00e0."})
    void testSentDetectWithInlineAbbreviationsResultsInOneSentence(String input) {
        SentenceDetectorME sentDetect = new SentenceDetectorME(sentdetectModel);
        String[] sents = sentDetect.sentDetect((CharSequence)input);
        Assertions.assertEquals((int)1, (int)sents.length);
        Assertions.assertEquals((Object)input, (Object)sents[0]);
        double[] probs = sentDetect.probs();
        Assertions.assertEquals((int)1, (int)probs.length);
    }

    @Test
    void testSentDetectWithInlineAbbreviationsResultsInTwoSentences() {
        String sent1 = "L' antico Conservatorio di S. Giuseppe e Teresa di Pucara del 1662 \u00e8 soggetto a speculazione edilizia.";
        String sent2 = "La consegna ha avuto luogo nell'auditorium S. Chiara di Trento, che per l'occasione era pieno.";
        String sampleSentences = "L' antico Conservatorio di S. Giuseppe e Teresa di Pucara del 1662 \u00e8 soggetto a speculazione edilizia. La consegna ha avuto luogo nell'auditorium S. Chiara di Trento, che per l'occasione era pieno.";
        SentenceDetectorME sentDetect = new SentenceDetectorME(sentdetectModel);
        String[] sents = sentDetect.sentDetect((CharSequence)sampleSentences);
        Assertions.assertEquals((int)2, (int)sents.length);
        Assertions.assertEquals((Object)"L' antico Conservatorio di S. Giuseppe e Teresa di Pucara del 1662 \u00e8 soggetto a speculazione edilizia.", (Object)sents[0]);
        Assertions.assertEquals((Object)"La consegna ha avuto luogo nell'auditorium S. Chiara di Trento, che per l'occasione era pieno.", (Object)sents[1]);
        double[] probs = sentDetect.probs();
        Assertions.assertEquals((int)2, (int)probs.length);
    }

    @Test
    void testSentDetectOpenNLP1163() throws IOException {
        SentenceDetectorME sentDetect = new SentenceDetectorME(sentdetectModel);
        String testResource = "/opennlp/tools/sentdetect/Test-Sample_OPENNLP-1163.txt";
        ResourceAsStreamFactory in = new ResourceAsStreamFactory(AbstractSentenceDetectorTest.class, "/opennlp/tools/sentdetect/Test-Sample_OPENNLP-1163.txt");
        ArrayList<String> detectedSentences = new ArrayList<String>();
        try (PlainTextByLineStream stream = new PlainTextByLineStream((InputStreamFactory)in, StandardCharsets.UTF_8);){
            String line;
            StringBuilder text = new StringBuilder();
            do {
                line = stream.read();
                text.append(line);
            } while (line != null);
            String[] sents = sentDetect.sentDetect((CharSequence)text.toString());
            detectedSentences.addAll(Arrays.asList(sents));
        }
        Assertions.assertEquals((int)11, (int)detectedSentences.size());
        for (String sent : detectedSentences) {
            Assertions.assertFalse((boolean)this.hasMisplacedAbbreviationAtEnd(sent));
        }
    }

    private boolean hasMisplacedAbbreviationAtEnd(String sent) {
        return sent.endsWith("dell'art.") || sent.endsWith("dall'art.") || sent.endsWith("nell'art.");
    }
}

