/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.IOException;
import java.util.Locale;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.sentdetect.AbstractSentenceDetectorTest;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class SentenceDetectorMEGermanTest
extends AbstractSentenceDetectorTest {
    private static final char[] EOS_CHARS = new char[]{'.', '?', '!'};
    private static Dictionary abbreviationDict;
    private SentenceModel sentdetectModel;
    private SentenceDetectorME sentenceDetector;

    @BeforeAll
    static void loadResources() throws IOException {
        abbreviationDict = SentenceDetectorMEGermanTest.loadAbbDictionary(Locale.GERMAN);
    }

    private void prepareResources(boolean useTokenEnd) {
        try {
            SentenceDetectorFactory factory = new SentenceDetectorFactory("deu", useTokenEnd, abbreviationDict, EOS_CHARS);
            this.sentdetectModel = SentenceDetectorMEGermanTest.train(factory, Locale.GERMAN);
            Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)this.sentdetectModel), () -> Assertions.assertEquals((Object)"deu", (Object)this.sentdetectModel.getLanguage())});
            this.sentenceDetector = new SentenceDetectorME(this.sentdetectModel);
        }
        catch (IOException ex) {
            Assertions.fail((String)("Couldn't train the SentenceModel using test data. Exception: " + ex.getMessage()));
        }
    }

    @Test
    void testSentDetectWithInlineAbbreviationsEx1() {
        this.prepareResources(true);
        String sent1 = "Ein Traum, zu dessen Bildung eine besonders starke Verdichtung beigetragen, wird f\u00fcr diese Untersuchung das g\u00fcnstigste Material sein.";
        String sent2 = "Ich w\u00e4hle den auf S. 183 ff. mitgeteilten Traum von der botanischen Monographie.";
        String sampleSentences = "Ein Traum, zu dessen Bildung eine besonders starke Verdichtung beigetragen, wird f\u00fcr diese Untersuchung das g\u00fcnstigste Material sein. Ich w\u00e4hle den auf S. 183 ff. mitgeteilten Traum von der botanischen Monographie.";
        String[] sents = this.sentenceDetector.sentDetect((CharSequence)sampleSentences);
        double[] probs = this.sentenceDetector.probs();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((int)2, (int)sents.length), () -> Assertions.assertEquals((Object)"Ein Traum, zu dessen Bildung eine besonders starke Verdichtung beigetragen, wird f\u00fcr diese Untersuchung das g\u00fcnstigste Material sein.", (Object)sents[0]), () -> Assertions.assertEquals((Object)"Ich w\u00e4hle den auf S. 183 ff. mitgeteilten Traum von der botanischen Monographie.", (Object)sents[1]), () -> Assertions.assertEquals((int)2, (int)probs.length)});
    }

    @Test
    void testSentDetectWithInlineAbbreviationsEx2() {
        this.prepareResources(true);
        String sent1 = "Die farbige Tafel, die ich aufschlage, geht (vgl. die Analyse S. 185 f.) auf ein neues Thema ein.";
        String[] sents = this.sentenceDetector.sentDetect((CharSequence)"Die farbige Tafel, die ich aufschlage, geht (vgl. die Analyse S. 185 f.) auf ein neues Thema ein.");
        double[] probs = this.sentenceDetector.probs();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((int)1, (int)sents.length), () -> Assertions.assertEquals((Object)"Die farbige Tafel, die ich aufschlage, geht (vgl. die Analyse S. 185 f.) auf ein neues Thema ein.", (Object)sents[0]), () -> Assertions.assertEquals((int)1, (int)probs.length)});
    }

    @Test
    void testSentDetectWithInlineAbbreviationsEx3() {
        this.prepareResources(true);
        String sent1 = "Die farbige Tafel, die ich aufschlage, geht (z. B. die Analyse S. 185) auf ein neues Thema ein.";
        String[] sents = this.sentenceDetector.sentDetect((CharSequence)"Die farbige Tafel, die ich aufschlage, geht (z. B. die Analyse S. 185) auf ein neues Thema ein.");
        double[] probs = this.sentenceDetector.probs();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((int)1, (int)sents.length), () -> Assertions.assertEquals((Object)"Die farbige Tafel, die ich aufschlage, geht (z. B. die Analyse S. 185) auf ein neues Thema ein.", (Object)sents[0]), () -> Assertions.assertEquals((int)1, (int)probs.length)});
    }

    @Test
    void testSentDetectWithUseTokenEndFalse() {
        this.prepareResources(false);
        String sent1 = "Tr\u00e4ume sind eine Verbindung von Gedanken.";
        String sent2 = "Verschiedene Gedanken sind w\u00e4hrend der Traumformation aktiv.";
        String[] sents = this.sentenceDetector.sentDetect((CharSequence)"Tr\u00e4ume sind eine Verbindung von Gedanken.Verschiedene Gedanken sind w\u00e4hrend der Traumformation aktiv.");
        double[] probs = this.sentenceDetector.probs();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((int)2, (int)sents.length), () -> Assertions.assertEquals((Object)"Tr\u00e4ume sind eine Verbindung von Gedanken.", (Object)sents[0]), () -> Assertions.assertEquals((Object)"Verschiedene Gedanken sind w\u00e4hrend der Traumformation aktiv.", (Object)sents[1]), () -> Assertions.assertEquals((int)2, (int)probs.length)});
    }

    @Test
    void testSentDetectWithAbbreviationsAtSentenceStart() {
        this.prepareResources(true);
        String sent1 = "S. Tr\u00e4ume sind eine Verbindung von Gedanken.";
        String[] sents = this.sentenceDetector.sentDetect((CharSequence)"S. Tr\u00e4ume sind eine Verbindung von Gedanken.");
        double[] probs = this.sentenceDetector.probs();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((int)1, (int)sents.length), () -> Assertions.assertEquals((Object)"S. Tr\u00e4ume sind eine Verbindung von Gedanken.", (Object)sents[0]), () -> Assertions.assertEquals((int)1, (int)probs.length)});
    }

    @ParameterizedTest
    @ValueSource(strings={"Die Frage wurde gestellt. Sie wurde beantwortet.", "Der Auto stand schief. Wer hat es dort geparkt?", "Es lag am DBMS. Die Performance muss verbessert werden.", "Siehe Buch S. 17f. Dort ist es zu finden.", "S. Buch S. 17f. Dort ist es zu finden.", "Sie trank einen Mocca. Er schmeckte ihr!", "Der Anker h\u00e4ngt zu Beginn des Bugs. Es ist vertaut.", "Das Verfahren testet auf HIV. Es ist pr\u00e4zise."})
    void testSentDetectWithOverlappingAbbreviationAtSentenceEnd(String input) {
        this.prepareResources(true);
        String[] sents = this.sentenceDetector.sentDetect((CharSequence)input);
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertNotNull((Object)sents), () -> Assertions.assertEquals((int)2, (int)sents.length), () -> Assertions.assertTrue((boolean)Character.isUpperCase(sents[0].charAt(0))), () -> Assertions.assertTrue((boolean)Character.isUpperCase(sents[1].charAt(0)))});
    }
}

