/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.IOException;
import java.util.Locale;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.sentdetect.AbstractSentenceDetectorTest;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class SentenceDetectorMEFrenchTest
extends AbstractSentenceDetectorTest {
    private static final char[] EOS_CHARS = new char[]{'.', '?', '!'};
    private static SentenceModel sentdetectModel;

    @BeforeAll
    public static void prepareResources() throws IOException {
        Dictionary abbreviationDict = SentenceDetectorMEFrenchTest.loadAbbDictionary(Locale.FRENCH);
        SentenceDetectorFactory factory = new SentenceDetectorFactory("fra", true, abbreviationDict, EOS_CHARS);
        sentdetectModel = SentenceDetectorMEFrenchTest.train(factory, Locale.FRENCH);
        Assertions.assertNotNull((Object)sentdetectModel);
        Assertions.assertEquals((Object)"fra", (Object)sentdetectModel.getLanguage());
    }

    @ParameterizedTest
    @ValueSource(strings={"Je choisis le r\u00eave de la monographie botanique communiqu\u00e9 \u00e0 la p. 205.", "Devant la surabondance des id\u00e9es incidentes que l\u2019analyse apporte \u00e0 propos de chacun des \u00e9l\u00e9ments du contenu de r\u00eave, un doute principiel s\u2019\u00e9veillera chez plus d\u2019un lecteur: peut-on donc compter au nombre des pens\u00e9es de r\u00eave tout ce qui, apr\u00e8s coup, vous vient \u00e0 l\u2019id\u00e9e dans l\u2019analyse, c.-\u00e0-d. peut-on supposer que toutes ces pens\u00e9es ont d\u00e9j\u00e0 \u00e9t\u00e9 actives pendant l\u2019\u00e9tat de sommeil et ont coop\u00e9r\u00e9 \u00e0 la formation du r\u00eave?"})
    void testSentDetectWithInlineAbbreviationsResultsInOneSentence(String input) {
        SentenceDetectorME sentDetect = new SentenceDetectorME(sentdetectModel);
        String[] sents = sentDetect.sentDetect((CharSequence)input);
        Assertions.assertEquals((int)1, (int)sents.length);
        Assertions.assertEquals((Object)input, (Object)sents[0]);
        double[] probs = sentDetect.probs();
        Assertions.assertEquals((int)1, (int)probs.length);
    }

    @Test
    void testSentDetectWithInlineAbbreviationsResultsInTwoSentences() {
        String sent1 = "La planche en couleurs que je d\u00e9plie conduit (cf. l\u2019analyse, p. 208) \u00e0 un nouveau th\u00e8me \u2013 les critiques que les confr\u00e8res font de mes travaux \u2013 et \u00e0 un th\u00e8me d\u00e9j\u00e0 repr\u00e9sent\u00e9 dans le r\u00eave, celui de mes occupations favorites, puis encore au souvenir d\u2019enfance o\u00f9 j\u2019arrache les pages d\u2019un livre aux planches en couleurs; l\u2019exemplaire s\u00e9ch\u00e9 de la plante touche \u00e0 l\u2019exp\u00e9rience de l\u2019herbier v\u00e9cue au lyc\u00e9e et fait particuli\u00e8rement ressortir ce souvenir.";
        String sent2 = "Je vois donc de quelle sorte est la relation entre le contenu du r\u00eave et les pens\u00e9es du r\u00eave: non seulement les \u00e9l\u00e9ments du r\u00eave sont d\u00e9termin\u00e9s de multiples fa\u00e7ons, mais les pens\u00e9es du r\u00eave prises une \u00e0 une sont aussi repr\u00e9sent\u00e9es dans le r\u00eave par plusieurs \u00e9l\u00e9ments.";
        String sampleSentences = "La planche en couleurs que je d\u00e9plie conduit (cf. l\u2019analyse, p. 208) \u00e0 un nouveau th\u00e8me \u2013 les critiques que les confr\u00e8res font de mes travaux \u2013 et \u00e0 un th\u00e8me d\u00e9j\u00e0 repr\u00e9sent\u00e9 dans le r\u00eave, celui de mes occupations favorites, puis encore au souvenir d\u2019enfance o\u00f9 j\u2019arrache les pages d\u2019un livre aux planches en couleurs; l\u2019exemplaire s\u00e9ch\u00e9 de la plante touche \u00e0 l\u2019exp\u00e9rience de l\u2019herbier v\u00e9cue au lyc\u00e9e et fait particuli\u00e8rement ressortir ce souvenir. Je vois donc de quelle sorte est la relation entre le contenu du r\u00eave et les pens\u00e9es du r\u00eave: non seulement les \u00e9l\u00e9ments du r\u00eave sont d\u00e9termin\u00e9s de multiples fa\u00e7ons, mais les pens\u00e9es du r\u00eave prises une \u00e0 une sont aussi repr\u00e9sent\u00e9es dans le r\u00eave par plusieurs \u00e9l\u00e9ments.";
        SentenceDetectorME sentDetect = new SentenceDetectorME(sentdetectModel);
        String[] sents = sentDetect.sentDetect((CharSequence)sampleSentences);
        Assertions.assertEquals((int)2, (int)sents.length);
        Assertions.assertEquals((Object)"La planche en couleurs que je d\u00e9plie conduit (cf. l\u2019analyse, p. 208) \u00e0 un nouveau th\u00e8me \u2013 les critiques que les confr\u00e8res font de mes travaux \u2013 et \u00e0 un th\u00e8me d\u00e9j\u00e0 repr\u00e9sent\u00e9 dans le r\u00eave, celui de mes occupations favorites, puis encore au souvenir d\u2019enfance o\u00f9 j\u2019arrache les pages d\u2019un livre aux planches en couleurs; l\u2019exemplaire s\u00e9ch\u00e9 de la plante touche \u00e0 l\u2019exp\u00e9rience de l\u2019herbier v\u00e9cue au lyc\u00e9e et fait particuli\u00e8rement ressortir ce souvenir.", (Object)sents[0]);
        Assertions.assertEquals((Object)"Je vois donc de quelle sorte est la relation entre le contenu du r\u00eave et les pens\u00e9es du r\u00eave: non seulement les \u00e9l\u00e9ments du r\u00eave sont d\u00e9termin\u00e9s de multiples fa\u00e7ons, mais les pens\u00e9es du r\u00eave prises une \u00e0 une sont aussi repr\u00e9sent\u00e9es dans le r\u00eave par plusieurs \u00e9l\u00e9ments.", (Object)sents[1]);
        double[] probs = sentDetect.probs();
        Assertions.assertEquals((int)2, (int)probs.length);
    }
}

