/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.IOException;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.sentdetect.AbstractSentenceDetectorTest;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class SentenceDetectorMEDutchTest
extends AbstractSentenceDetectorTest {
    private static final char[] EOS_CHARS = new char[]{'.', '?', '!'};
    private static SentenceModel sentdetectModel;

    @BeforeAll
    public static void prepareResources() throws IOException {
        Dictionary abbreviationDict = SentenceDetectorMEDutchTest.loadAbbDictionary(LOCALE_DUTCH);
        SentenceDetectorFactory factory = new SentenceDetectorFactory("dut", true, abbreviationDict, EOS_CHARS);
        sentdetectModel = SentenceDetectorMEDutchTest.train(factory, LOCALE_DUTCH);
        Assertions.assertNotNull((Object)sentdetectModel);
        Assertions.assertEquals((Object)"dut", (Object)sentdetectModel.getLanguage());
    }

    @Test
    void testSentDetectWithInlineAbbreviationsEx1() {
        String sent1 = "Een droom, tot de vorming waarvan een bijzonder sterke compressie heeft bijgedragen, zal het meest gunstige materiaal zijn voor dit onderzoek.";
        String sent2 = "Ik kies voor de droom van de botanische monografie die op p. 183 en volgende wordt beschreven.";
        SentenceDetectorME sentDetect = new SentenceDetectorME(sentdetectModel);
        String sampleSentences = "Een droom, tot de vorming waarvan een bijzonder sterke compressie heeft bijgedragen, zal het meest gunstige materiaal zijn voor dit onderzoek. Ik kies voor de droom van de botanische monografie die op p. 183 en volgende wordt beschreven.";
        String[] sents = sentDetect.sentDetect((CharSequence)sampleSentences);
        Assertions.assertEquals((int)2, (int)sents.length);
        Assertions.assertEquals((Object)"Een droom, tot de vorming waarvan een bijzonder sterke compressie heeft bijgedragen, zal het meest gunstige materiaal zijn voor dit onderzoek.", (Object)sents[0]);
        Assertions.assertEquals((Object)"Ik kies voor de droom van de botanische monografie die op p. 183 en volgende wordt beschreven.", (Object)sents[1]);
        double[] probs = sentDetect.probs();
        Assertions.assertEquals((int)2, (int)probs.length);
    }

    @Test
    void testSentDetectWithInlineAbbreviationsEx2() {
        String sent1 = "Met het oog op de overvloed aan idee\u00ebn die de analyse op elk afzonderlijk element van de droominhoud brengt, zullen sommige lezers twijfels hebben over het principe of alles wat later tijdens de analyse in je opkomt, tot de droomgedachten gerekend mag worden, d.w.z. of aangenomen mag worden dat al deze gedachten al tijdens de slaaptoestand actief waren en bijdroegen aan de vorming van de droom?";
        SentenceDetectorME sentDetect = new SentenceDetectorME(sentdetectModel);
        String[] sents = sentDetect.sentDetect((CharSequence)"Met het oog op de overvloed aan idee\u00ebn die de analyse op elk afzonderlijk element van de droominhoud brengt, zullen sommige lezers twijfels hebben over het principe of alles wat later tijdens de analyse in je opkomt, tot de droomgedachten gerekend mag worden, d.w.z. of aangenomen mag worden dat al deze gedachten al tijdens de slaaptoestand actief waren en bijdroegen aan de vorming van de droom?");
        Assertions.assertEquals((int)1, (int)sents.length);
        Assertions.assertEquals((Object)"Met het oog op de overvloed aan idee\u00ebn die de analyse op elk afzonderlijk element van de droominhoud brengt, zullen sommige lezers twijfels hebben over het principe of alles wat later tijdens de analyse in je opkomt, tot de droomgedachten gerekend mag worden, d.w.z. of aangenomen mag worden dat al deze gedachten al tijdens de slaaptoestand actief waren en bijdroegen aan de vorming van de droom?", (Object)sents[0]);
        double[] probs = sentDetect.probs();
        Assertions.assertEquals((int)1, (int)probs.length);
    }

    @Test
    void testSentDetectWithInlineAbbreviationsEx3() {
        String sent1 = "De gekleurde plaat die ik openmaak (zie de analyse pag. 185 e.v.) verwijst naar een nieuw thema, de kritiek van collega's op mijn werk, en naar een thema dat al in de droom voorkomt, mijn hobby's, en ook naar de jeugdherinnering waarin ik een boek met gekleurde platen uit elkaar pluk, het gedroogde exemplaar van de plant raakt aan de gymnasiumervaring met het herbarium en benadrukt deze herinnering in het bijzonder.";
        SentenceDetectorME sentDetect = new SentenceDetectorME(sentdetectModel);
        String[] sents = sentDetect.sentDetect((CharSequence)"De gekleurde plaat die ik openmaak (zie de analyse pag. 185 e.v.) verwijst naar een nieuw thema, de kritiek van collega's op mijn werk, en naar een thema dat al in de droom voorkomt, mijn hobby's, en ook naar de jeugdherinnering waarin ik een boek met gekleurde platen uit elkaar pluk, het gedroogde exemplaar van de plant raakt aan de gymnasiumervaring met het herbarium en benadrukt deze herinnering in het bijzonder.");
        Assertions.assertEquals((int)1, (int)sents.length);
        Assertions.assertEquals((Object)"De gekleurde plaat die ik openmaak (zie de analyse pag. 185 e.v.) verwijst naar een nieuw thema, de kritiek van collega's op mijn werk, en naar een thema dat al in de droom voorkomt, mijn hobby's, en ook naar de jeugdherinnering waarin ik een boek met gekleurde platen uit elkaar pluk, het gedroogde exemplaar van de plant raakt aan de gymnasiumervaring met het herbarium en benadrukt deze herinnering in het bijzonder.", (Object)sents[0]);
        double[] probs = sentDetect.probs();
        Assertions.assertEquals((int)1, (int)probs.length);
    }
}

