/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.sentdetect.AbstractSentenceDetectorTest;
import opennlp.tools.sentdetect.DefaultEndOfSentenceScanner;
import opennlp.tools.sentdetect.DefaultSDContextGenerator;
import opennlp.tools.sentdetect.DummySentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.sentdetect.lang.Factory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SentenceDetectorFactoryTest
extends AbstractSentenceDetectorTest {
    @Test
    void testDefault() throws IOException {
        Dictionary dic = SentenceDetectorFactoryTest.loadAbbDictionary(Locale.ENGLISH);
        char[] eos = new char[]{'.', '?'};
        SentenceModel sdModel = SentenceDetectorFactoryTest.train(new SentenceDetectorFactory("eng", true, dic, eos), Locale.ENGLISH);
        SentenceDetectorFactory factory = sdModel.getFactory();
        Assertions.assertInstanceOf(DefaultSDContextGenerator.class, (Object)factory.getSDContextGenerator());
        Assertions.assertInstanceOf(DefaultEndOfSentenceScanner.class, (Object)factory.getEndOfSentenceScanner());
        Assertions.assertArrayEquals((char[])eos, (char[])factory.getEOSCharacters());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        sdModel.serialize((OutputStream)out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        SentenceModel fromSerialized = new SentenceModel((InputStream)in);
        factory = fromSerialized.getFactory();
        Assertions.assertInstanceOf(DefaultSDContextGenerator.class, (Object)factory.getSDContextGenerator());
        Assertions.assertInstanceOf(DefaultEndOfSentenceScanner.class, (Object)factory.getEndOfSentenceScanner());
        Assertions.assertArrayEquals((char[])eos, (char[])factory.getEOSCharacters());
    }

    @Test
    void testNullDict() throws IOException {
        Dictionary dic = null;
        char[] eos = new char[]{'.', '?'};
        SentenceModel sdModel = SentenceDetectorFactoryTest.train(new SentenceDetectorFactory("eng", true, dic, eos), Locale.ENGLISH);
        SentenceDetectorFactory factory = sdModel.getFactory();
        Assertions.assertNull((Object)factory.getAbbreviationDictionary());
        Assertions.assertInstanceOf(DefaultSDContextGenerator.class, (Object)factory.getSDContextGenerator());
        Assertions.assertInstanceOf(DefaultEndOfSentenceScanner.class, (Object)factory.getEndOfSentenceScanner());
        Assertions.assertArrayEquals((char[])eos, (char[])factory.getEOSCharacters());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        sdModel.serialize((OutputStream)out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        SentenceModel fromSerialized = new SentenceModel((InputStream)in);
        factory = fromSerialized.getFactory();
        Assertions.assertNull((Object)factory.getAbbreviationDictionary());
        Assertions.assertInstanceOf(DefaultSDContextGenerator.class, (Object)factory.getSDContextGenerator());
        Assertions.assertInstanceOf(DefaultEndOfSentenceScanner.class, (Object)factory.getEndOfSentenceScanner());
        Assertions.assertArrayEquals((char[])eos, (char[])factory.getEOSCharacters());
    }

    @Test
    void testDefaultEOS() throws IOException {
        Dictionary dic = null;
        char[] eos = null;
        SentenceModel sdModel = SentenceDetectorFactoryTest.train(new SentenceDetectorFactory("eng", true, dic, eos), Locale.ENGLISH);
        SentenceDetectorFactory factory = sdModel.getFactory();
        Assertions.assertNull((Object)factory.getAbbreviationDictionary());
        Assertions.assertInstanceOf(DefaultSDContextGenerator.class, (Object)factory.getSDContextGenerator());
        Assertions.assertInstanceOf(DefaultEndOfSentenceScanner.class, (Object)factory.getEndOfSentenceScanner());
        Assertions.assertArrayEquals((char[])Factory.defaultEosCharacters, (char[])factory.getEOSCharacters());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        sdModel.serialize((OutputStream)out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        SentenceModel fromSerialized = new SentenceModel((InputStream)in);
        factory = fromSerialized.getFactory();
        Assertions.assertNull((Object)factory.getAbbreviationDictionary());
        Assertions.assertInstanceOf(DefaultSDContextGenerator.class, (Object)factory.getSDContextGenerator());
        Assertions.assertInstanceOf(DefaultEndOfSentenceScanner.class, (Object)factory.getEndOfSentenceScanner());
        Assertions.assertArrayEquals((char[])Factory.defaultEosCharacters, (char[])factory.getEOSCharacters());
    }

    @Test
    void testDummyFactory() throws IOException {
        Dictionary dic = SentenceDetectorFactoryTest.loadAbbDictionary(Locale.ENGLISH);
        char[] eos = new char[]{'.', '?'};
        SentenceModel sdModel = SentenceDetectorFactoryTest.train(new DummySentenceDetectorFactory("eng", true, dic, eos), Locale.ENGLISH);
        SentenceDetectorFactory factory = sdModel.getFactory();
        Assertions.assertInstanceOf(DummySentenceDetectorFactory.DummyDictionary.class, (Object)factory.getAbbreviationDictionary());
        Assertions.assertInstanceOf(DummySentenceDetectorFactory.DummySDContextGenerator.class, (Object)factory.getSDContextGenerator());
        Assertions.assertInstanceOf(DummySentenceDetectorFactory.DummyEOSScanner.class, (Object)factory.getEndOfSentenceScanner());
        Assertions.assertArrayEquals((char[])eos, (char[])factory.getEOSCharacters());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        sdModel.serialize((OutputStream)out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        SentenceModel fromSerialized = new SentenceModel((InputStream)in);
        factory = fromSerialized.getFactory();
        Assertions.assertInstanceOf(DummySentenceDetectorFactory.DummyDictionary.class, (Object)factory.getAbbreviationDictionary());
        Assertions.assertInstanceOf(DummySentenceDetectorFactory.DummySDContextGenerator.class, (Object)factory.getSDContextGenerator());
        Assertions.assertInstanceOf(DummySentenceDetectorFactory.DummyEOSScanner.class, (Object)factory.getEndOfSentenceScanner());
        Assertions.assertArrayEquals((char[])eos, (char[])factory.getEOSCharacters());
        Assertions.assertEquals((Object)factory.getAbbreviationDictionary(), (Object)sdModel.getAbbreviations());
        Assertions.assertArrayEquals((char[])factory.getEOSCharacters(), (char[])sdModel.getEosCharacters());
    }

    @Test
    void testCreateDummyFactory() throws IOException {
        Dictionary dic = SentenceDetectorFactoryTest.loadAbbDictionary(Locale.ENGLISH);
        char[] eos = new char[]{'.', '?'};
        SentenceDetectorFactory factory = SentenceDetectorFactory.create((String)DummySentenceDetectorFactory.class.getCanonicalName(), (String)"spa", (boolean)false, (Dictionary)dic, (char[])eos);
        Assertions.assertInstanceOf(DummySentenceDetectorFactory.DummyDictionary.class, (Object)factory.getAbbreviationDictionary());
        Assertions.assertInstanceOf(DummySentenceDetectorFactory.DummySDContextGenerator.class, (Object)factory.getSDContextGenerator());
        Assertions.assertInstanceOf(DummySentenceDetectorFactory.DummyEOSScanner.class, (Object)factory.getEndOfSentenceScanner());
        Assertions.assertArrayEquals((char[])eos, (char[])factory.getEOSCharacters());
    }
}

