/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import opennlp.tools.cmdline.sentdetect.SentenceEvaluationErrorListener;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.sentdetect.SentenceDetectorEvaluationMonitor;
import opennlp.tools.sentdetect.SentenceDetectorEvaluator;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.sentdetect.SentenceSampleTest;
import opennlp.tools.util.Span;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SentenceDetectorEvaluatorTest {
    @Test
    void testPositive() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        SentenceEvaluationErrorListener listener = new SentenceEvaluationErrorListener((OutputStream)stream);
        SentenceDetectorEvaluator eval = new SentenceDetectorEvaluator((SentenceDetector)new DummySD(SentenceSampleTest.createGoldSample()), new SentenceDetectorEvaluationMonitor[]{listener});
        eval.evaluateSample((Object)SentenceSampleTest.createGoldSample());
        Assertions.assertEquals((double)1.0, (double)eval.getFMeasure().getFMeasure());
        Assertions.assertEquals((int)0, (int)((Object)stream).toString().length());
    }

    @Test
    void testNegative() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        SentenceEvaluationErrorListener listener = new SentenceEvaluationErrorListener((OutputStream)stream);
        SentenceDetectorEvaluator eval = new SentenceDetectorEvaluator((SentenceDetector)new DummySD(SentenceSampleTest.createGoldSample()), new SentenceDetectorEvaluationMonitor[]{listener});
        eval.evaluateSample((Object)SentenceSampleTest.createPredSample());
        Assertions.assertEquals((double)-1.0, (double)eval.getFMeasure().getFMeasure(), (double)0.1);
        Assertions.assertNotSame((Object)0, (Object)((Object)stream).toString().length());
    }

    public static class DummySD
    implements SentenceDetector {
        private final SentenceSample sample;

        public DummySD(SentenceSample sample) {
            this.sample = sample;
        }

        public String[] sentDetect(CharSequence s) {
            return null;
        }

        public Span[] sentPosDetect(CharSequence s) {
            return this.sample.getSentences();
        }
    }
}

