/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import opennlp.tools.sentdetect.NewlineSentenceDetector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NewlineSentenceDetectorTest {
    private static void testSentenceValues(String sentences) {
        NewlineSentenceDetector sd = new NewlineSentenceDetector();
        String[] results = sd.sentDetect((CharSequence)sentences);
        Assertions.assertEquals((int)3, (int)results.length);
        Assertions.assertEquals((Object)"one.", (Object)results[0]);
        Assertions.assertEquals((Object)"two.", (Object)results[1]);
        Assertions.assertEquals((Object)"three.", (Object)results[2]);
    }

    @Test
    void testNewlineCr() {
        NewlineSentenceDetectorTest.testSentenceValues("one.\rtwo. \r\r three.\r");
    }

    @Test
    void testNewlineLf() {
        NewlineSentenceDetectorTest.testSentenceValues("one.\ntwo. \n\n three.\n");
    }

    @Test
    void testNewlineCrLf() {
        NewlineSentenceDetectorTest.testSentenceValues("one.\r\ntwo. \r\n\r\n three.\r\n");
    }
}

