/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.sentdetect.DefaultEndOfSentenceScanner;
import opennlp.tools.sentdetect.DefaultSDContextGenerator;
import opennlp.tools.sentdetect.EndOfSentenceScanner;
import opennlp.tools.sentdetect.SDContextGenerator;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.util.model.ArtifactSerializer;

public class DummySentenceDetectorFactory
extends SentenceDetectorFactory {
    private static final String DUMMY_DICT = "dummy";
    private DummyDictionary dict;

    public DummySentenceDetectorFactory() {
    }

    public DummySentenceDetectorFactory(String languageCode, boolean useTokenEnd, Dictionary abbreviationDictionary, char[] eosCharacters) {
        super(languageCode, useTokenEnd, abbreviationDictionary, eosCharacters);
    }

    protected void init(String languageCode, boolean useTokenEnd, Dictionary abbreviationDictionary, char[] eosCharacters) {
        super.init(languageCode, useTokenEnd, abbreviationDictionary, eosCharacters);
        this.dict = new DummyDictionary(abbreviationDictionary);
    }

    public DummyDictionary getAbbreviationDictionary() {
        if (this.dict == null && this.artifactProvider != null) {
            this.dict = (DummyDictionary)((Object)this.artifactProvider.getArtifact(DUMMY_DICT));
        }
        return this.dict;
    }

    public SDContextGenerator getSDContextGenerator() {
        return new DummySDContextGenerator(this.getAbbreviationDictionary().asStringSet(), this.getEOSCharacters());
    }

    public EndOfSentenceScanner getEndOfSentenceScanner() {
        return new DummyEOSScanner(this.getEOSCharacters());
    }

    public Map<String, ArtifactSerializer<?>> createArtifactSerializersMap() {
        Map serializers = super.createArtifactSerializersMap();
        serializers.put(DUMMY_DICT, new DummyDictionarySerializer());
        return serializers;
    }

    public Map<String, Object> createArtifactMap() {
        Map artifactMap = super.createArtifactMap();
        if (this.dict != null) {
            artifactMap.put(DUMMY_DICT, this.dict);
        }
        return artifactMap;
    }

    public static class DummyDictionary
    extends Dictionary {
        private final Dictionary indict;

        public DummyDictionary(Dictionary dict) {
            this.indict = dict;
        }

        public DummyDictionary(InputStream in) throws IOException {
            this.indict = new Dictionary(in);
        }

        public void serialize(OutputStream out) throws IOException {
            this.indict.serialize(out);
        }

        public Set<String> asStringSet() {
            return this.indict.asStringSet();
        }

        public Class<?> getArtifactSerializerClass() {
            return DummyDictionarySerializer.class;
        }
    }

    static class DummySDContextGenerator
    extends DefaultSDContextGenerator {
        public DummySDContextGenerator(Set<String> inducedAbbreviations, char[] eosCharacters) {
            super(inducedAbbreviations, eosCharacters);
        }
    }

    static class DummyEOSScanner
    extends DefaultEndOfSentenceScanner {
        public DummyEOSScanner(char[] eosCharacters) {
            super(eosCharacters);
        }
    }

    public static class DummyDictionarySerializer
    implements ArtifactSerializer<DummyDictionary> {
        public DummyDictionary create(InputStream in) throws IOException {
            return new DummyDictionary(in);
        }

        public void serialize(DummyDictionary artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

