/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import opennlp.tools.sentdetect.DefaultSDContextGenerator;
import opennlp.tools.sentdetect.lang.Factory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultSDContextGeneratorTest {
    @Test
    void testGetContext() {
        DefaultSDContextGenerator sdContextGenerator = new DefaultSDContextGenerator(Collections.emptySet(), Factory.defaultEosCharacters);
        Object[] context = sdContextGenerator.getContext((CharSequence)"Mr. Smith joined RONDHUIT Inc. as a manager of sales department.", 2);
        Assertions.assertArrayEquals((Object[])"sn/eos=./x=Mr/2/xcap/v=/s=/n=Smith/ncap".split("/"), (Object[])context);
        context = sdContextGenerator.getContext((CharSequence)"Mr. Smith joined RONDHUIT Inc. as a manager of sales department.", 29);
        Assertions.assertArrayEquals((Object[])"sn/eos=./x=Inc/3/xcap/v=RONDHUIT/vcap/s=/n=as".split("/"), (Object[])context);
    }

    @Test
    void testGetContextWithAbbreviations() {
        DefaultSDContextGenerator sdContextGenerator = new DefaultSDContextGenerator(new HashSet<String>(Arrays.asList("Mr./Inc.".split("/"))), Factory.defaultEosCharacters);
        Object[] context = sdContextGenerator.getContext((CharSequence)"Mr. Smith joined RONDHUIT Inc. as a manager of sales department.", 2);
        Assertions.assertArrayEquals((Object[])"sn/eos=./x=Mr/2/xcap/xabbrev/v=/s=/n=Smith/ncap".split("/"), (Object[])context);
        context = sdContextGenerator.getContext((CharSequence)"Mr. Smith joined RONDHUIT Inc. as a manager of sales department.", 29);
        Assertions.assertArrayEquals((Object[])"sn/eos=./x=Inc/3/xcap/xabbrev/v=RONDHUIT/vcap/s=/n=as".split("/"), (Object[])context);
    }
}

