/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.formats.ResourceAsStreamFactory;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.sentdetect.SentenceSampleStream;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;

public abstract class AbstractSentenceDetectorTest {
    protected static final Locale LOCALE_DUTCH = new Locale("nl");
    protected static final Locale LOCALE_POLISH = new Locale("pl");
    protected static final Locale LOCALE_PORTUGUESE = new Locale("pt");
    protected static final Locale LOCALE_SPANISH = new Locale("es");

    static ObjectStream<SentenceSample> createSampleStream(Locale loc) throws IOException {
        String trainingResource = loc.equals(LOCALE_DUTCH) ? "/opennlp/tools/sentdetect/Sentences_NL.txt" : (loc.equals(Locale.GERMAN) ? "/opennlp/tools/sentdetect/Sentences_DE.txt" : (loc.equals(Locale.FRENCH) ? "/opennlp/tools/sentdetect/Sentences_FR.txt" : (loc.equals(Locale.ITALIAN) ? "/opennlp/tools/sentdetect/Sentences_IT.txt" : (loc.equals(LOCALE_POLISH) ? "/opennlp/tools/sentdetect/Sentences_PL.txt" : (loc.equals(LOCALE_PORTUGUESE) ? "/opennlp/tools/sentdetect/Sentences_PT.txt" : (loc.equals(LOCALE_SPANISH) ? "/opennlp/tools/sentdetect/Sentences_ES.txt" : "/opennlp/tools/sentdetect/Sentences.txt"))))));
        ResourceAsStreamFactory in = new ResourceAsStreamFactory(AbstractSentenceDetectorTest.class, trainingResource);
        return new SentenceSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)in, StandardCharsets.UTF_8));
    }

    static SentenceModel train(SentenceDetectorFactory factory, Locale loc) throws IOException {
        String lang = loc.equals(LOCALE_DUTCH) ? "dut" : (loc.equals(Locale.GERMAN) ? "deu" : (loc.equals(Locale.FRENCH) ? "fra" : (loc.equals(Locale.ITALIAN) ? "ita" : (loc.equals(LOCALE_POLISH) ? "pol" : (loc.equals(LOCALE_PORTUGUESE) ? "por" : (loc.equals(LOCALE_SPANISH) ? "spa" : "eng"))))));
        return SentenceDetectorME.train((String)lang, AbstractSentenceDetectorTest.createSampleStream(loc), (SentenceDetectorFactory)factory, (TrainingParameters)TrainingParameters.defaultParams());
    }

    static Dictionary loadAbbDictionary(Locale loc) throws IOException {
        String abbrevDict = loc.equals(LOCALE_DUTCH) ? "opennlp/tools/lang/abb_NL.xml" : (loc.equals(Locale.GERMAN) ? "opennlp/tools/lang/abb_DE.xml" : (loc.equals(Locale.FRENCH) ? "opennlp/tools/lang/abb_FR.xml" : (loc.equals(Locale.ITALIAN) ? "opennlp/tools/lang/abb_IT.xml" : (loc.equals(LOCALE_POLISH) ? "opennlp/tools/lang/abb_PT.xml" : (loc.equals(LOCALE_PORTUGUESE) ? "opennlp/tools/lang/abb_PT.xml" : (loc.equals(LOCALE_SPANISH) ? "opennlp/tools/lang/abb_ES.xml" : "opennlp/tools/lang/abb_EN.xml"))))));
        return new Dictionary(AbstractSentenceDetectorTest.class.getClassLoader().getResourceAsStream(abbrevDict));
    }
}

