/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.IOException;
import java.util.ArrayList;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.WordTagSampleStream;
import opennlp.tools.util.CollectionObjectStream;
import opennlp.tools.util.ObjectStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WordTagSampleStreamTest {
    @Test
    void testParseSimpleSample() throws IOException {
        ArrayList<String> sampleString = new ArrayList<String>(1);
        sampleString.add("This_x1 is_x2 a_x3 test_x4 sentence_x5 ._x6");
        try (WordTagSampleStream stream = new WordTagSampleStream((ObjectStream)new CollectionObjectStream(sampleString));){
            POSSample sample = stream.read();
            String[] words = sample.getSentence();
            Assertions.assertEquals((Object)"This", (Object)words[0]);
            Assertions.assertEquals((Object)"is", (Object)words[1]);
            Assertions.assertEquals((Object)"a", (Object)words[2]);
            Assertions.assertEquals((Object)"test", (Object)words[3]);
            Assertions.assertEquals((Object)"sentence", (Object)words[4]);
            Assertions.assertEquals((Object)".", (Object)words[5]);
            String[] tags = sample.getTags();
            Assertions.assertEquals((Object)"x1", (Object)tags[0]);
            Assertions.assertEquals((Object)"x2", (Object)tags[1]);
            Assertions.assertEquals((Object)"x3", (Object)tags[2]);
            Assertions.assertEquals((Object)"x4", (Object)tags[3]);
            Assertions.assertEquals((Object)"x5", (Object)tags[4]);
            Assertions.assertEquals((Object)"x6", (Object)tags[5]);
            Assertions.assertNull((Object)stream.read());
            stream.reset();
            Assertions.assertNotNull((Object)stream.read());
        }
    }
}

