/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import opennlp.tools.AbstractModelLoaderTest;
import opennlp.tools.EnabledWhenCDNAvailable;
import opennlp.tools.formats.ResourceAsStreamFactory;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTagFormat;
import opennlp.tools.postag.POSTagger;
import opennlp.tools.postag.POSTaggerFactory;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.postag.WordTagSampleStream;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.InsufficientTrainingDataException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class POSTaggerMETest
extends AbstractModelLoaderTest {
    private static final String[] sentence = new String[]{"The", "driver", "got", "badly", "injured", "by", "the", "accident", "."};

    private static ObjectStream<POSSample> createSampleStream() throws IOException {
        ResourceAsStreamFactory in = new ResourceAsStreamFactory(POSTaggerMETest.class, "/opennlp/tools/postag/AnnotatedSentences.txt");
        return new WordTagSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)in, StandardCharsets.UTF_8));
    }

    public static POSModel trainPennFormatPOSModel(ModelType type) throws IOException {
        TrainingParameters params = new TrainingParameters();
        params.put("Algorithm", type.toString());
        params.put("Iterations", 100);
        params.put("Cutoff", 5);
        return POSTaggerME.train((String)"eng", POSTaggerMETest.createSampleStream(), (TrainingParameters)params, (POSTaggerFactory)new POSTaggerFactory());
    }

    @Test
    void testPOSTagger() throws IOException {
        String[] expected = new String[]{"DT", "NN", "VBD", "RB", "VBN", "IN", "DT", "NN", "."};
        this.testPOSTagger((POSTagger)new POSTaggerME(POSTaggerMETest.trainPennFormatPOSModel(ModelType.MAXENT), POSTagFormat.PENN), sentence, expected);
    }

    @Test
    void testPOSTaggerPENNtoUD() throws IOException {
        String[] expected = new String[]{"DET", "NOUN", "VERB", "ADV", "VERB", "ADP", "DET", "NOUN", "PUNCT"};
        this.testPOSTagger((POSTagger)new POSTaggerME(POSTaggerMETest.trainPennFormatPOSModel(ModelType.MAXENT), POSTagFormat.UD), sentence, expected);
    }

    @Test
    void testPOSTaggerMappingNoOp() throws IOException {
        String[] expected = new String[]{"DT", "NN", "VBD", "RB", "VBN", "IN", "DT", "NN", "."};
        this.testPOSTagger((POSTagger)new POSTaggerME(POSTaggerMETest.trainPennFormatPOSModel(ModelType.MAXENT), POSTagFormat.CUSTOM), sentence, expected);
    }

    @Test
    @EnabledWhenCDNAvailable(hostname="dlcdn.apache.org")
    void testPOSTaggerDefault() throws IOException {
        String[] expected = new String[]{"DET", "NOUN", "VERB", "ADV", "VERB", "ADP", "DET", "NOUN", "PUNCT"};
        this.testPOSTagger((POSTagger)new POSTaggerME("en"), sentence, expected);
    }

    @Test
    @EnabledWhenCDNAvailable(hostname="opennlp.sourceforge.net")
    void testPOSTaggerLegacyPerceptronPennToUD() throws IOException {
        String[] expected = new String[]{"DET", "NOUN", "VERB", "ADV", "VERB", "ADP", "DET", "NOUN", "PUNCT"};
        this.testPOSTagger((POSTagger)new POSTaggerME(this.getVersion15Model("en-pos-perceptron.bin"), POSTagFormat.UD), sentence, expected);
    }

    @Test
    @EnabledWhenCDNAvailable(hostname="opennlp.sourceforge.net")
    void testPOSTaggerLegacyPerceptronPenn() throws IOException {
        String[] expected = new String[]{"DT", "NN", "VBD", "RB", "VBN", "IN", "DT", "NN", "."};
        this.testPOSTagger((POSTagger)new POSTaggerME(this.getVersion15Model("en-pos-perceptron.bin"), POSTagFormat.PENN), sentence, expected);
    }

    @Test
    @EnabledWhenCDNAvailable(hostname="opennlp.sourceforge.net")
    void testPOSTaggerLegacyMaxentPennToUD() throws IOException {
        String[] expected = new String[]{"DET", "NOUN", "VERB", "ADV", "VERB", "ADP", "DET", "NOUN", "PUNCT"};
        this.testPOSTagger((POSTagger)new POSTaggerME(this.getVersion15Model("en-pos-maxent.bin"), POSTagFormat.UD), sentence, expected);
    }

    @Test
    @EnabledWhenCDNAvailable(hostname="opennlp.sourceforge.net")
    void testPOSTaggerLegacyMaxentPenn() throws IOException {
        String[] expected = new String[]{"DT", "NN", "VBD", "RB", "VBN", "IN", "DT", "NN", "."};
        this.testPOSTagger((POSTagger)new POSTaggerME(this.getVersion15Model("en-pos-maxent.bin"), POSTagFormat.PENN), sentence, expected);
    }

    private POSModel getVersion15Model(String modelName) throws IOException {
        POSTaggerMETest.downloadVersion15Model(modelName);
        Path modelPath = OPENNLP_DIR.resolve(modelName);
        return new POSModel(modelPath);
    }

    private void testPOSTagger(POSTagger tagger, String[] sentences, String[] expectedTags) {
        Assertions.assertArrayEquals((Object[])expectedTags, (Object[])tagger.tag(sentences));
    }

    @Test
    void testBuildNGramDictionary() throws IOException {
        ObjectStream<POSSample> samples = POSTaggerMETest.createSampleStream();
        POSTaggerME.buildNGramDictionary(samples, (int)0);
    }

    @Test
    void insufficientTestData() {
        Assertions.assertThrows(InsufficientTrainingDataException.class, () -> {
            ResourceAsStreamFactory in = new ResourceAsStreamFactory(POSTaggerMETest.class, "/opennlp/tools/postag/AnnotatedSentencesInsufficient.txt");
            WordTagSampleStream stream = new WordTagSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)in, StandardCharsets.UTF_8));
            TrainingParameters params = new TrainingParameters();
            params.put("Algorithm", ModelType.MAXENT.name());
            params.put("Iterations", 100);
            params.put("Cutoff", 5);
            POSTaggerME.train((String)"eng", (ObjectStream)stream, (TrainingParameters)params, (POSTaggerFactory)new POSTaggerFactory());
        });
    }
}

