/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import opennlp.tools.postag.POSTagger;
import opennlp.tools.postag.ThreadSafePOSTaggerME;
import opennlp.tools.tokenize.ThreadSafeTokenizerME;
import opennlp.tools.tokenize.Tokenizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class POSTaggerMEIT {
    private static final String CATALAN = "ca";
    private static final String ENGLISH = "en";
    private static final String GERMAN = "de";
    private static final String POLISH = "pl";
    private static final String PORTUGUESE = "pt";
    private static final Map<String, Tokenizer> TOKENIZERS = new HashMap<String, Tokenizer>();
    private static final Map<String, POSTagger> TAGGERS = new HashMap<String, POSTagger>();
    private static final boolean debug = false;

    @BeforeAll
    public static void initResources() throws IOException {
        List<String> langs = List.of(CATALAN, ENGLISH, GERMAN, POLISH, PORTUGUESE);
        for (String langCode : langs) {
            TOKENIZERS.put(langCode, (Tokenizer)new ThreadSafeTokenizerME(langCode));
            TAGGERS.put(langCode, (POSTagger)new ThreadSafePOSTaggerME(langCode));
        }
    }

    @ParameterizedTest(name="Verify \"{0}\" sample")
    @MethodSource(value={"provideData"})
    void testPOSTagger(String langCode, int allowedDelta, String input, String[] expectedTags) {
        String[] tokens = TOKENIZERS.get(langCode).tokenize(input);
        Assertions.assertNotNull((Object)tokens);
        Assertions.assertEquals((int)expectedTags.length, (int)tokens.length);
        String[] tags = TAGGERS.get(langCode).tag(tokens);
        Assertions.assertNotNull((Object)tags);
        Assertions.assertEquals((int)expectedTags.length, (int)tags.length);
        StringBuilder fullyTagged = new StringBuilder();
        for (int i = 0; i < tags.length; ++i) {
            fullyTagged.append(tokens[i]).append("_").append(tags[i]).append(" ");
        }
        ArrayList<Integer> incorrectTagsPositions = new ArrayList<Integer>();
        for (int i = 0; i < tags.length; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append(tokens[i]).append("[").append(tags[i]).append("]");
            if (expectedTags[i].equals(tags[i])) {
                sb.append(" <-- OK");
                continue;
            }
            sb.append(" <-- NOK, pos=").append(i);
            incorrectTagsPositions.add(i);
        }
        Assertions.assertTrue((incorrectTagsPositions.size() <= allowedDelta ? 1 : 0) != 0);
    }

    private static Stream<Arguments> provideData() {
        return Stream.of(Arguments.of((Object[])new Object[]{ENGLISH, 0, "Mr. Vinken is chairman of Elsevier N.V. , the Dutch publishing group .", new String[]{"PROPN", "PROPN", "AUX", "NOUN", "ADP", "ADJ", "PROPN", "PUNCT", "DET", "PROPN", "VERB", "NOUN", "PUNCT"}}), Arguments.of((Object[])new Object[]{GERMAN, 0, "Fachlich kompetent, sehr gute Beratung und ein freundliches Team .", new String[]{"ADJ", "ADJ", "PUNCT", "ADV", "ADJ", "NOUN", "CCONJ", "DET", "ADJ", "NOUN", "PUNCT"}}), Arguments.of((Object[])new Object[]{PORTUGUESE, 1, "Numa reuni\u00e3o entre representantes da Secretaria da Crian\u00e7a do DF ea ju\u00edza da Vara de Execu\u00e7\u00f5es de Medidas Socioeducativas, Lav\u00ednia Tupi Vieira Fonseca, ficou acordado que dos 25 internos, 12 ser\u00e3o internados na Unidade de Planaltina e os outros 13 devem retornar para a Unidade do Recanto das Emas, antigo Ciago .", new String[]{"ADP+DET", "NOUN", "ADP", "NOUN", "ADP+DET", "PROPN", "ADP+DET", "PROPN", "ADP+DET", "PROPN", "CCONJ", "NOUN", "ADP+DET", "PROPN", "ADP", "PROPN", "ADP", "PROPN", "PROPN", "PUNCT", "PROPN", "PROPN", "PROPN", "PROPN", "PUNCT", "VERB", "ADJ", "CCONJ", "ADP+DET", "NUM", "NOUN", "PUNCT", "NUM", "AUX", "VERB", "ADP+DET", "PROPN", "ADP", "PROPN", "CCONJ", "DET", "DET", "NUM", "AUX", "VERB", "ADP", "DET", "PROPN", "ADP+DET", "PROPN", "ADP+DET", "PROPN", "PUNCT", "ADJ", "PROPN", "PUNCT"}}), Arguments.of((Object[])new Object[]{POLISH, 1, "Zerwa\u0142em si\u0119 ze stosu zwini\u0119tych spadochron\u00f3w i pobieg\u0142em prosto do radiostacji .", new String[]{"VERB+AUX", "PART", "ADP", "NOUN", "ADJ", "NOUN", "CCONJ", "VERB+AUX", "ADV", "ADP", "NOUN", "PUNCT"}}), Arguments.of((Object[])new Object[]{POLISH, 0, "Wi\u0119zienie nie tkwi na zewn\u0105trz, ale jest w \u015brodku ka\u017cdego z nas .", new String[]{"NOUN", "PART", "VERB", "ADP", "ADV", "PUNCT", "CCONJ", "VERB", "ADP", "NOUN", "DET", "ADP", "PRON", "PUNCT"}}), Arguments.of((Object[])new Object[]{POLISH, 0, "Dzia\u0142acze stosowali te\u017c r\u00f3\u017cne formy nacisku na polski konsulat , \u017ceby zaopiekowa\u0142 si\u0119 bezrobotnymi z Polski albo da\u0142 im cho\u0107by na bezp\u0142atny bilet do kraju .", new String[]{"NOUN", "VERB", "PART", "ADJ", "NOUN", "NOUN", "ADP", "ADJ", "NOUN", "PUNCT", "SCONJ", "VERB", "PRON", "ADJ", "ADP", "PROPN", "CCONJ", "VERB", "PRON", "PART", "ADP", "ADJ", "NOUN", "ADP", "NOUN", "PUNCT"}}), Arguments.of((Object[])new Object[]{CATALAN, 1, "Un gran embossament d'aire fred es comen\u00e7a a despenjar cap al centre d'Europa.", new String[]{"DET", "ADJ", "NOUN", "ADP", "NOUN", "ADJ", "PRON", "VERB", "ADP", "VERB", "NOUN", "ADP+DET", "NOUN", "ADP", "PROPN", "PUNCT"}}));
    }
}

