/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import opennlp.tools.formats.ResourceAsStreamFactory;
import opennlp.tools.postag.DefaultPOSSequenceValidator;
import opennlp.tools.postag.DummyPOSTaggerFactory;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.POSDictionaryTest;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTaggerFactory;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.postag.TagDictionary;
import opennlp.tools.postag.WordTagSampleStream;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class POSTaggerFactoryTest {
    private static ObjectStream<POSSample> createSampleStream() throws IOException {
        ResourceAsStreamFactory in = new ResourceAsStreamFactory(POSTaggerFactoryTest.class, "/opennlp/tools/postag/AnnotatedSentences.txt");
        return new WordTagSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)in, StandardCharsets.UTF_8));
    }

    private static POSModel trainPOSModel(POSTaggerFactory factory) throws IOException {
        return POSTaggerME.train((String)"eng", POSTaggerFactoryTest.createSampleStream(), (TrainingParameters)TrainingParameters.defaultParams(), (POSTaggerFactory)factory);
    }

    @Test
    void testPOSTaggerWithCustomFactory() throws IOException {
        DummyPOSTaggerFactory.DummyPOSDictionary posDict = new DummyPOSTaggerFactory.DummyPOSDictionary(POSDictionary.create((InputStream)POSDictionaryTest.class.getResourceAsStream("TagDictionaryCaseSensitive.xml")));
        POSModel posModel = POSTaggerFactoryTest.trainPOSModel(new DummyPOSTaggerFactory(posDict));
        POSTaggerFactory factory = posModel.getFactory();
        Assertions.assertInstanceOf(DummyPOSTaggerFactory.DummyPOSDictionary.class, (Object)factory.getTagDictionary());
        Assertions.assertInstanceOf(DummyPOSTaggerFactory.DummyPOSContextGenerator.class, (Object)factory.getPOSContextGenerator());
        Assertions.assertInstanceOf(DummyPOSTaggerFactory.DummyPOSSequenceValidator.class, (Object)factory.getSequenceValidator());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        posModel.serialize((OutputStream)out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        POSModel fromSerialized = new POSModel((InputStream)in);
        factory = fromSerialized.getFactory();
        Assertions.assertInstanceOf(DummyPOSTaggerFactory.DummyPOSDictionary.class, (Object)factory.getTagDictionary());
        Assertions.assertInstanceOf(DummyPOSTaggerFactory.DummyPOSContextGenerator.class, (Object)factory.getPOSContextGenerator());
        Assertions.assertInstanceOf(DummyPOSTaggerFactory.DummyPOSSequenceValidator.class, (Object)factory.getSequenceValidator());
    }

    @Test
    void testPOSTaggerWithDefaultFactory() throws IOException {
        POSDictionary posDict = POSDictionary.create((InputStream)POSDictionaryTest.class.getResourceAsStream("TagDictionaryCaseSensitive.xml"));
        POSModel posModel = POSTaggerFactoryTest.trainPOSModel(new POSTaggerFactory(null, null, (TagDictionary)posDict));
        POSTaggerFactory factory = posModel.getFactory();
        Assertions.assertInstanceOf(POSDictionary.class, (Object)factory.getTagDictionary());
        Assertions.assertNotNull((Object)factory.getPOSContextGenerator());
        Assertions.assertInstanceOf(DefaultPOSSequenceValidator.class, (Object)factory.getSequenceValidator());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        posModel.serialize((OutputStream)out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        POSModel fromSerialized = new POSModel((InputStream)in);
        factory = fromSerialized.getFactory();
        Assertions.assertInstanceOf(POSDictionary.class, (Object)factory.getTagDictionary());
        Assertions.assertNotNull((Object)factory.getPOSContextGenerator());
        Assertions.assertInstanceOf(DefaultPOSSequenceValidator.class, (Object)factory.getSequenceValidator());
    }

    @Test
    void testCreateWithInvalidName() {
        Assertions.assertThrows(InvalidFormatException.class, () -> BaseToolFactory.create((String)"X", null));
    }

    @Test
    void testCreateWithHierarchy() {
        Assertions.assertThrows(InvalidFormatException.class, () -> BaseToolFactory.create((String)Object.class.getCanonicalName(), null));
    }
}

