/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.InvalidFormatException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class POSSampleTest {
    @Test
    void testEquals() throws InvalidFormatException {
        Assertions.assertNotSame((Object)POSSampleTest.createGoldSample(), (Object)POSSampleTest.createGoldSample());
        Assertions.assertEquals((Object)POSSampleTest.createGoldSample(), (Object)POSSampleTest.createGoldSample());
        Assertions.assertNotEquals((Object)POSSampleTest.createPredSample(), (Object)POSSampleTest.createGoldSample());
        Assertions.assertNotEquals((Object)new Object(), (Object)POSSampleTest.createPredSample());
    }

    public static POSSample createGoldSample() throws InvalidFormatException {
        String sentence = "the_DT stories_NNS about_IN well-heeled_JJ communities_NNS and_CC developers_NNS";
        return POSSample.parse((String)sentence);
    }

    public static POSSample createPredSample() throws InvalidFormatException {
        String sentence = "the_DT stories_NNS about_NNS well-heeled_JJ communities_NNS and_CC developers_CC";
        return POSSample.parse((String)sentence);
    }

    @Test
    void testPOSSampleSerDe() throws IOException {
        POSSample posSample = POSSampleTest.createGoldSample();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteArrayOutputStream);
        out.writeObject(posSample);
        out.flush();
        byte[] bytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        ObjectInputStream objectInput = new ObjectInputStream(byteArrayInputStream);
        POSSample deSerializedPOSSample = null;
        try {
            deSerializedPOSSample = (POSSample)objectInput.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Assertions.assertNotNull((Object)deSerializedPOSSample);
        Assertions.assertArrayEquals((Object[])posSample.getAdditionalContext(), (Object[])deSerializedPOSSample.getAdditionalContext());
        Assertions.assertArrayEquals((Object[])posSample.getSentence(), (Object[])deSerializedPOSSample.getSentence());
        Assertions.assertArrayEquals((Object[])posSample.getTags(), (Object[])deSerializedPOSSample.getTags());
    }

    @Test
    void testParse() throws InvalidFormatException {
        String sentence = "the_DT stories_NNS about_IN well-heeled_JJ communities_NNS and_CC developers_NNS";
        POSSample sample = POSSample.parse((String)sentence);
        Assertions.assertEquals((Object)sentence, (Object)sample.toString());
    }

    @Test
    void testParseEmptyString() throws InvalidFormatException {
        String sentence = "";
        POSSample sample = POSSample.parse((String)sentence);
        Assertions.assertEquals((int)0, (int)sample.getSentence().length);
        Assertions.assertEquals((int)0, (int)sample.getTags().length);
    }

    @Test
    void testParseEmtpyToken() throws InvalidFormatException {
        String sentence = "the_DT _NNS";
        POSSample sample = POSSample.parse((String)sentence);
        Assertions.assertEquals((Object)"", (Object)sample.getSentence()[1]);
    }

    @Test
    void testParseEmtpyTag() throws InvalidFormatException {
        String sentence = "the_DT stories_";
        POSSample sample = POSSample.parse((String)sentence);
        Assertions.assertEquals((Object)"", (Object)sample.getTags()[1]);
    }

    @Test
    void testParseWithError() {
        String sentence = "the_DT stories";
        try {
            POSSample.parse((String)sentence);
        }
        catch (InvalidFormatException e) {
            return;
        }
        Assertions.fail();
    }
}

