/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTaggerMETest;
import opennlp.tools.util.model.ModelType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class POSModelTest {
    @Test
    void testPOSModelSerializationMaxent() throws IOException {
        POSModel posModel = POSTaggerMETest.trainPennFormatPOSModel(ModelType.MAXENT);
        Assertions.assertFalse((boolean)posModel.isLoadedFromSerialized());
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            posModel.serialize((OutputStream)out);
            POSModel recreatedPosModel = new POSModel((InputStream)new ByteArrayInputStream(out.toByteArray()));
            Assertions.assertNotNull((Object)recreatedPosModel);
            Assertions.assertTrue((boolean)recreatedPosModel.isLoadedFromSerialized());
            Assertions.assertEquals((Object)posModel, (Object)recreatedPosModel);
        }
    }

    @Test
    void testPOSModelSerializationPerceptron() throws IOException {
        POSModel posModel = POSTaggerMETest.trainPennFormatPOSModel(ModelType.PERCEPTRON);
        Assertions.assertFalse((boolean)posModel.isLoadedFromSerialized());
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            posModel.serialize((OutputStream)out);
            POSModel recreatedPosModel = new POSModel((InputStream)new ByteArrayInputStream(out.toByteArray()));
            Assertions.assertTrue((boolean)recreatedPosModel.isLoadedFromSerialized());
            Assertions.assertEquals((Object)posModel, (Object)recreatedPosModel);
        }
    }
}

