/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import opennlp.tools.cmdline.postag.POSEvaluationErrorListener;
import opennlp.tools.postag.POSEvaluator;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSSampleTest;
import opennlp.tools.postag.POSTagger;
import opennlp.tools.postag.POSTaggerEvaluationMonitor;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.Sequence;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class POSEvaluatorTest {
    @Test
    void testPositive() throws InvalidFormatException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        POSEvaluationErrorListener listener = new POSEvaluationErrorListener((OutputStream)stream);
        POSEvaluator eval = new POSEvaluator((POSTagger)new DummyPOSTagger(POSSampleTest.createGoldSample()), new POSTaggerEvaluationMonitor[]{listener});
        eval.evaluateSample((Object)POSSampleTest.createGoldSample());
        Assertions.assertEquals((double)1.0, (double)eval.getWordAccuracy(), (double)0.0);
        Assertions.assertEquals((int)0, (int)((Object)stream).toString().length());
    }

    @Test
    void testNegative() throws InvalidFormatException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        POSEvaluationErrorListener listener = new POSEvaluationErrorListener((OutputStream)stream);
        POSEvaluator eval = new POSEvaluator((POSTagger)new DummyPOSTagger(POSSampleTest.createGoldSample()), new POSTaggerEvaluationMonitor[]{listener});
        eval.evaluateSample((Object)POSSampleTest.createPredSample());
        Assertions.assertEquals((double)0.7, (double)eval.getWordAccuracy(), (double)0.1);
        Assertions.assertNotSame((Object)0, (Object)((Object)stream).toString().length());
    }

    static class DummyPOSTagger
    implements POSTagger {
        private final POSSample sample;

        public DummyPOSTagger(POSSample sample) {
            this.sample = sample;
        }

        public List<String> tag(List<String> sentence) {
            return Arrays.asList(this.sample.getTags());
        }

        public String[] tag(String[] sentence) {
            return this.sample.getTags();
        }

        public String tag(String sentence) {
            return null;
        }

        public Sequence[] topKSequences(List<String> sentence) {
            return null;
        }

        public Sequence[] topKSequences(String[] sentence) {
            return null;
        }

        public String[] tag(String[] sentence, Object[] additionalContext) {
            return this.tag(sentence);
        }

        public Sequence[] topKSequences(String[] sentence, Object[] additionalContext) {
            return this.topKSequences(sentence);
        }
    }
}

