/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import opennlp.tools.postag.POSDictionary;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class POSDictionaryTest {
    private static POSDictionary loadDictionary(String name) throws IOException {
        return POSDictionary.create((InputStream)POSDictionaryTest.class.getResourceAsStream(name));
    }

    private static POSDictionary serializeDeserializeDict(POSDictionary dict) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            POSDictionary serializedDictionary;
            dict.serialize((OutputStream)out);
            try (ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());){
                serializedDictionary = POSDictionary.create((InputStream)in);
            }
            POSDictionary pOSDictionary = serializedDictionary;
            return pOSDictionary;
        }
    }

    @Test
    void testSerialization() throws IOException {
        POSDictionary dictionary = new POSDictionary();
        dictionary.put("a", new String[]{"1", "2", "3"});
        dictionary.put("b", new String[]{"4", "5", "6"});
        dictionary.put("c", new String[]{"7", "8", "9"});
        dictionary.put("Always", new String[]{"RB", "NNP"});
        Assertions.assertEquals((Object)dictionary, (Object)POSDictionaryTest.serializeDeserializeDict(dictionary));
    }

    @Test
    void testLoadingDictionaryWithoutCaseAttribute() throws IOException {
        POSDictionary dict = POSDictionaryTest.loadDictionary("TagDictionaryWithoutCaseAttribute.xml");
        Assertions.assertArrayEquals((Object[])new String[]{"NNP"}, (Object[])dict.getTags("McKinsey"));
        Assertions.assertNull((Object)dict.getTags("Mckinsey"));
    }

    @Test
    void testCaseSensitiveDictionary() throws IOException {
        POSDictionary dict = POSDictionaryTest.loadDictionary("TagDictionaryCaseSensitive.xml");
        Assertions.assertArrayEquals((Object[])new String[]{"NNP"}, (Object[])dict.getTags("McKinsey"));
        Assertions.assertNull((Object)dict.getTags("Mckinsey"));
        dict = POSDictionaryTest.serializeDeserializeDict(dict);
        Assertions.assertArrayEquals((Object[])new String[]{"NNP"}, (Object[])dict.getTags("McKinsey"));
        Assertions.assertNull((Object)dict.getTags("Mckinsey"));
    }

    @Test
    void testCaseInsensitiveDictionary() throws IOException {
        POSDictionary dict = POSDictionaryTest.loadDictionary("TagDictionaryCaseInsensitive.xml");
        Assertions.assertArrayEquals((Object[])new String[]{"NNP"}, (Object[])dict.getTags("McKinsey"));
        Assertions.assertArrayEquals((Object[])new String[]{"NNP"}, (Object[])dict.getTags("Mckinsey"));
        Assertions.assertArrayEquals((Object[])new String[]{"NNP"}, (Object[])dict.getTags("MCKINSEY"));
        Assertions.assertArrayEquals((Object[])new String[]{"NNP"}, (Object[])dict.getTags("mckinsey"));
        dict = POSDictionaryTest.serializeDeserializeDict(dict);
        Assertions.assertArrayEquals((Object[])new String[]{"NNP"}, (Object[])dict.getTags("McKinsey"));
        Assertions.assertArrayEquals((Object[])new String[]{"NNP"}, (Object[])dict.getTags("Mckinsey"));
    }

    @Test
    void testToString() throws IOException {
        POSDictionary dict = POSDictionaryTest.loadDictionary("TagDictionaryCaseInsensitive.xml");
        Assertions.assertEquals((Object)"POSDictionary{size=1, caseSensitive=false}", (Object)dict.toString());
        dict = POSDictionaryTest.loadDictionary("TagDictionaryCaseSensitive.xml");
        Assertions.assertEquals((Object)"POSDictionary{size=1, caseSensitive=true}", (Object)dict.toString());
    }

    @Test
    void testEqualsAndHashCode() throws IOException {
        POSDictionary dictA = POSDictionaryTest.loadDictionary("TagDictionaryCaseInsensitive.xml");
        POSDictionary dictB = POSDictionaryTest.loadDictionary("TagDictionaryCaseInsensitive.xml");
        Assertions.assertEquals((Object)dictA, (Object)dictB);
        Assertions.assertEquals((int)dictA.hashCode(), (int)dictB.hashCode());
    }
}

