/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.postag.DefaultPOSContextGenerator;
import opennlp.tools.postag.POSContextGenerator;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.POSTaggerFactory;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.UncloseableInputStream;

public class DummyPOSTaggerFactory
extends POSTaggerFactory {
    private static final String DUMMY_POSDICT = "DUMMY_POSDICT";
    private DummyPOSDictionary dict;

    public DummyPOSTaggerFactory() {
    }

    public DummyPOSTaggerFactory(DummyPOSDictionary posDictionary) {
        super(null, null, null);
        this.dict = posDictionary;
    }

    public SequenceValidator<String> getSequenceValidator() {
        return new DummyPOSSequenceValidator();
    }

    public DummyPOSDictionary getTagDictionary() {
        return (DummyPOSDictionary)((Object)this.artifactProvider.getArtifact(DUMMY_POSDICT));
    }

    public POSContextGenerator getPOSContextGenerator() {
        return new DummyPOSContextGenerator(this.ngramDictionary);
    }

    public Map<String, ArtifactSerializer<?>> createArtifactSerializersMap() {
        Map serializers = super.createArtifactSerializersMap();
        serializers.put(DUMMY_POSDICT, new DummyPOSDictionarySerializer());
        return serializers;
    }

    public Map<String, Object> createArtifactMap() {
        Map artifactMap = super.createArtifactMap();
        if (this.dict != null) {
            artifactMap.put(DUMMY_POSDICT, this.dict);
        }
        return artifactMap;
    }

    public static class DummyPOSDictionary
    extends POSDictionary {
        private POSDictionary dict;

        public DummyPOSDictionary() {
        }

        public DummyPOSDictionary(POSDictionary dict) {
            this.dict = dict;
        }

        public static DummyPOSDictionary create(UncloseableInputStream uncloseableInputStream) throws IOException {
            return new DummyPOSDictionary(POSDictionary.create((InputStream)uncloseableInputStream));
        }

        public void serialize(OutputStream out) throws IOException {
            this.dict.serialize(out);
        }

        public String[] getTags(String word) {
            return this.dict.getTags(word);
        }

        public Class<?> getArtifactSerializerClass() {
            return DummyPOSDictionarySerializer.class;
        }
    }

    static class DummyPOSSequenceValidator
    implements SequenceValidator<String> {
        DummyPOSSequenceValidator() {
        }

        public boolean validSequence(int i, String[] inputSequence, String[] outcomesSequence, String outcome) {
            return true;
        }
    }

    static class DummyPOSContextGenerator
    extends DefaultPOSContextGenerator {
        public DummyPOSContextGenerator(Dictionary dict) {
            super(dict);
        }
    }

    public static class DummyPOSDictionarySerializer
    implements ArtifactSerializer<DummyPOSDictionary> {
        public DummyPOSDictionary create(InputStream in) throws IOException {
            return DummyPOSDictionary.create(new UncloseableInputStream(in));
        }

        public void serialize(DummyPOSDictionary artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

