/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.postag.DefaultPOSContextGenerator;
import opennlp.tools.util.StringList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class DefaultPOSContextGeneratorTest {
    public static final int NUMBER_OF_THREADS = 10;
    private static Object[] tokens;
    private static DefaultPOSContextGenerator defaultPOSContextGenerator;
    private static String[] tags;

    @BeforeAll
    static void setUp() {
        String matchingToken = "tokenC";
        tokens = new Object[]{"tokenA", "tokenB", "tokenC", "tokenD"};
        StringList stringList = new StringList(new String[]{"tokenC"});
        Dictionary dictionary = new Dictionary();
        dictionary.put(stringList);
        defaultPOSContextGenerator = new DefaultPOSContextGenerator(dictionary);
        tags = new String[]{"tagA", "tagB", "tagC", "tagD"};
    }

    @Test
    void noDictionaryMatch() {
        int index = 1;
        Object[] actual = defaultPOSContextGenerator.getContext(index, tokens, tags);
        Object[] expected = new String[]{"default", "w=tokenB", "suf=B", "suf=nB", "suf=enB", "suf=kenB", "pre=t", "pre=to", "pre=tok", "pre=toke", "c", "p=tokenA", "t=tagA", "pp=*SB*", "n=tokenC", "nn=tokenD"};
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual, (String)("Calling with not matching index at: " + index + "\nexpected \n" + Arrays.toString(expected) + " but actually was \n" + Arrays.toString(actual)));
    }

    @Test
    void dictionaryMatch() {
        int indexWithDictionaryMatch = 2;
        Object[] actual = defaultPOSContextGenerator.getContext(indexWithDictionaryMatch, tokens, tags);
        Object[] expected = new String[]{"default", "w=tokenC", "p=tokenB", "t=tagB", "pp=tokenA", "t2=tagA,tagB", "n=tokenD", "nn=*SE*"};
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual, (String)("Calling with index matching dictionary entry at: " + indexWithDictionaryMatch + "\nexpected \n" + Arrays.toString(expected) + " but actually was \n" + Arrays.toString(actual)));
    }

    @Test
    void multithreading() {
        Callable<Void> matching = () -> {
            this.dictionaryMatch();
            return null;
        };
        Callable<Void> notMatching = () -> {
            this.noDictionaryMatch();
            return null;
        };
        List callables = IntStream.range(0, 200000).mapToObj(index -> index % 2 == 0 ? matching : notMatching).collect(Collectors.toList());
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        try {
            List<Future<Future>> futures = executorService.invokeAll(callables);
            executorService.shutdown();
            executorService.awaitTermination(30L, TimeUnit.SECONDS);
            futures.forEach(future -> {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    Assertions.fail((String)("Interrupted because of: " + e.getCause().getMessage()));
                }
                catch (ExecutionException ee) {
                    Assertions.fail((String)ee.getCause().getMessage());
                }
            });
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"Test interrupted");
        }
    }
}

