/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import opennlp.tools.postag.ConfigurablePOSContextGenerator;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.TokenFeatureGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfigurablePOSContextGeneratorTest {
    private void testContextGeneration(int cacheSize) {
        TokenFeatureGenerator fg = new TokenFeatureGenerator();
        ConfigurablePOSContextGenerator cg = new ConfigurablePOSContextGenerator(cacheSize, (AdaptiveFeatureGenerator)fg);
        String[] tokens = new String[]{"a", "b", "c", "d", "e"};
        String[] tags = new String[]{"t_a", "t_b", "t_c", "t_d", "t_e"};
        cg.getContext(0, tokens, tags, null);
        Assertions.assertEquals((int)1, (int)cg.getContext(0, tokens, tags, null).length);
        Assertions.assertEquals((Object)"w=a", (Object)cg.getContext(0, tokens, tags, null)[0]);
        Assertions.assertEquals((Object)"w=b", (Object)cg.getContext(1, tokens, tags, null)[0]);
        Assertions.assertEquals((Object)"w=c", (Object)cg.getContext(2, tokens, tags, null)[0]);
        Assertions.assertEquals((Object)"w=d", (Object)cg.getContext(3, tokens, tags, null)[0]);
        Assertions.assertEquals((Object)"w=e", (Object)cg.getContext(4, tokens, tags, null)[0]);
    }

    @Test
    void testWithoutCache() {
        this.testContextGeneration(0);
    }

    @Test
    void testWithCache() {
        this.testContextGeneration(3);
    }
}

