/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import opennlp.tools.formats.ResourceAsStreamFactory;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParseSampleStream;
import opennlp.tools.parser.lang.en.HeadRules;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import org.junit.jupiter.api.Assertions;

public class ParserTestUtil {
    public static HeadRules createTestHeadRules() throws IOException {
        try (InputStream headRulesIn = ParserTestUtil.class.getResourceAsStream("/opennlp/tools/parser/en_head_rules");){
            HeadRules headRules;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(headRulesIn, StandardCharsets.UTF_8));){
                headRules = new HeadRules((Reader)reader);
            }
            return headRules;
        }
    }

    public static ObjectStream<Parse> openTestTrainingData() throws IOException {
        ObjectStream<Parse> resetableSampleStream = new ObjectStream<Parse>(){
            private ObjectStream<Parse> samples;

            public void close() throws IOException {
                this.samples.close();
            }

            public Parse read() throws IOException {
                return (Parse)this.samples.read();
            }

            public void reset() throws IOException {
                try {
                    if (this.samples != null) {
                        this.samples.close();
                    }
                    ResourceAsStreamFactory in = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/parser/parser.train");
                    this.samples = new ParseSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)in, StandardCharsets.UTF_8));
                }
                catch (UnsupportedEncodingException e) {
                    Assertions.fail((String)e.getMessage());
                }
            }
        };
        resetableSampleStream.reset();
        return resetableSampleStream;
    }
}

