/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import opennlp.tools.formats.ResourceAsStreamFactory;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParseSampleStream;
import opennlp.tools.parser.Parser;
import opennlp.tools.parser.ParserEvaluationMonitor;
import opennlp.tools.parser.ParserEvaluator;
import opennlp.tools.parser.ParserFactory;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.parser.lang.en.HeadRules;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.FMeasure;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ParserEvaluatorTest {
    private Parser parser;

    @BeforeEach
    public void setup() throws IOException {
        ResourceAsStreamFactory in = new ResourceAsStreamFactory(this.getClass(), "/opennlp/tools/parser/parser.train");
        ParseSampleStream samples = new ParseSampleStream((ObjectStream)new PlainTextByLineStream((InputStreamFactory)in, StandardCharsets.UTF_8));
        Assertions.assertNotNull((Object)samples);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try (InputStream headRulesIn = cl.getResourceAsStream("opennlp/tools/parser/en_head_rules");){
            HeadRules headRules = new HeadRules((Reader)new BufferedReader(new InputStreamReader(headRulesIn, StandardCharsets.UTF_8)));
            ParserModel model = opennlp.tools.parser.chunking.Parser.train((String)"en", (ObjectStream)samples, (opennlp.tools.parser.HeadRules)headRules, (TrainingParameters)TrainingParameters.defaultParams());
            this.parser = ParserFactory.create((ParserModel)model);
            Assertions.assertNotNull((Object)this.parser);
        }
    }

    @Test
    void testProcessSample() {
        String goldParseString = "(TOP (S (NP (NNS Sales) (NNS executives)) (VP (VBD were) (VP (VBG examing) (NP (DT the) (NNS figures)) (PP (IN with) (NP (JJ great) (NN care))) ))  (NP (NN yesterday)) (. .) ))";
        ParserEvaluator pe = new ParserEvaluator(this.parser, new ParserEvaluationMonitor[0]);
        Parse p = pe.processSample(Parse.parseParse((String)goldParseString));
        Assertions.assertNotNull((Object)p);
        FMeasure measure = pe.getFMeasure();
        Assertions.assertNotNull((Object)measure);
        Assertions.assertEquals((double)0.42857142857142855, (double)measure.getPrecisionScore(), (double)0.0);
        Assertions.assertEquals((double)0.375, (double)measure.getRecallScore(), (double)0.0);
        Assertions.assertEquals((double)0.39999999999999997, (double)measure.getFMeasure(), (double)0.0);
    }
}

