/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import opennlp.tools.parser.Parse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ParseTest {
    public static final String PARSE_STRING = "(TOP  (S (S (NP-SBJ (PRP She)  )(VP (VBD was)  (ADVP (RB just)  )(NP-PRD (NP (DT another)  (NN freighter)  )(PP (IN from)  (NP (DT the)  (NNPS States)  )))))(, ,)  (CC and) (S (NP-SBJ (PRP she)  )(VP (VBD seemed)  (ADJP-PRD (ADJP (RB as)  (JJ commonplace)  )(PP (IN as)  (NP (PRP$ her)  (NN name)  )))))(. .)  ))";

    @Test
    void testToHashCode() {
        Parse p1 = Parse.parseParse((String)PARSE_STRING);
        p1.hashCode();
    }

    @Test
    void testToString() {
        Parse p1 = Parse.parseParse((String)PARSE_STRING);
        p1.toString();
    }

    @Test
    void testEquals() {
        Parse p1 = Parse.parseParse((String)PARSE_STRING);
        Assertions.assertEquals((Object)p1, (Object)p1);
    }

    @Test
    void testParseClone() {
        Parse p1 = Parse.parseParse((String)PARSE_STRING);
        Parse p2 = (Parse)p1.clone();
        Assertions.assertEquals((Object)p1, (Object)p2);
        Assertions.assertEquals((Object)p2, (Object)p1);
    }

    @Test
    void testGetText() {
        Parse p = Parse.parseParse((String)PARSE_STRING);
        String expectedText = "She was just another freighter from the States , and she seemed as commonplace as her name . ";
        Assertions.assertEquals((Object)expectedText, (Object)p.getText());
    }

    @Test
    void testShow() {
        Parse p1 = Parse.parseParse((String)PARSE_STRING);
        StringBuffer parseString = new StringBuffer();
        p1.show(parseString);
        Parse p2 = Parse.parseParse((String)parseString.toString());
        Assertions.assertEquals((Object)p1, (Object)p2);
    }

    @Test
    void testTokenReplacement() {
        Parse p1 = Parse.parseParse((String)"(TOP  (S-CLF (NP-SBJ (PRP It)  )(VP (VBD was)  (NP-PRD (NP (DT the)  (NN trial)  )(PP (IN of)  (NP (NP (NN oleomargarine)  (NN heir)  )(NP (NNP Minot)  (PRN (-LRB- -LRB-) (NNP Mickey)  (-RRB- -RRB-) )(NNP Jelke)  )))(PP (IN for)  (NP (JJ compulsory)  (NN prostitution)  ))(PP-LOC (IN in)  (NP (NNP New)  (NNP York)  )))(SBAR (WHNP-1 (WDT that)  )(S (VP (VBD put)  (NP (DT the)  (NN spotlight)  )(PP (IN on)  (NP (DT the)  (JJ international)  (NN play-girl)  ))))))(. .)  ))");
        StringBuffer parseString = new StringBuffer();
        p1.show(parseString);
        Parse p2 = Parse.parseParse((String)parseString.toString());
        Assertions.assertEquals((Object)p1, (Object)p2);
    }

    @Test
    void testGetTagNodes() {
        Parse[] tags;
        Parse p = Parse.parseParse((String)PARSE_STRING);
        for (Parse node : tags = p.getTagNodes()) {
            Assertions.assertTrue((boolean)node.isPosTag());
        }
        Assertions.assertEquals((Object)"PRP", (Object)tags[0].getType());
        Assertions.assertEquals((Object)"VBD", (Object)tags[1].getType());
        Assertions.assertEquals((Object)"RB", (Object)tags[2].getType());
        Assertions.assertEquals((Object)"DT", (Object)tags[3].getType());
        Assertions.assertEquals((Object)"NN", (Object)tags[4].getType());
        Assertions.assertEquals((Object)"IN", (Object)tags[5].getType());
        Assertions.assertEquals((Object)"DT", (Object)tags[6].getType());
        Assertions.assertEquals((Object)"NNPS", (Object)tags[7].getType());
        Assertions.assertEquals((Object)",", (Object)tags[8].getType());
        Assertions.assertEquals((Object)"CC", (Object)tags[9].getType());
        Assertions.assertEquals((Object)"PRP", (Object)tags[10].getType());
        Assertions.assertEquals((Object)"VBD", (Object)tags[11].getType());
        Assertions.assertEquals((Object)"RB", (Object)tags[12].getType());
        Assertions.assertEquals((Object)"JJ", (Object)tags[13].getType());
        Assertions.assertEquals((Object)"IN", (Object)tags[14].getType());
        Assertions.assertEquals((Object)"PRP$", (Object)tags[15].getType());
        Assertions.assertEquals((Object)"NN", (Object)tags[16].getType());
        Assertions.assertEquals((Object)".", (Object)tags[17].getType());
    }
}

